/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.IOException;
import java.util.HashSet;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;

public class BAMPairIterator
implements PairIterator {
    AlignmentPair nextPair = null;
    CloseableIterator<Alignment> iterator;
    HashSet<String> added = new HashSet(10000);
    private AlignmentQueryReader reader;

    public BAMPairIterator(String path) throws IOException {
        this.reader = AlignmentReaderFactory.getReader(path, false);
        this.iterator = this.reader.iterator();
        this.advance();
    }

    private void advance() {
        while (this.iterator.hasNext()) {
            Alignment alignment = (Alignment)this.iterator.next();
            String readName = alignment.getReadName();
            if (this.added.contains(readName)) {
                this.added.remove(readName);
                continue;
            }
            ReadMate mate = alignment.getMate();
            if (!alignment.isProperPair() || !alignment.isMapped() || alignment.getMappingQuality() <= 0 || mate == null || !mate.isMapped()) continue;
            this.nextPair = new AlignmentPair(alignment.getChr(), alignment.getStart(), mate.getChr(), mate.getStart());
            this.added.add(readName);
        }
        this.nextPair = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextPair != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair p2 = this.nextPair;
        this.advance();
        return p2;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        this.iterator.close();
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

