/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;
import org.apache.batik.gvt.event.GraphicsNodeEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.text.Mark;

public class ConcreteTextSelector
implements Selector {
    private ArrayList listeners;
    private GraphicsNode selectionNode;
    private RootGraphicsNode selectionNodeRoot;

    public void mouseClicked(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseDragged(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseEntered(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseExited(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseMoved(GraphicsNodeMouseEvent evt) {
    }

    public void mousePressed(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseReleased(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void keyPressed(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyPressed");
    }

    public void keyReleased(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyReleased");
    }

    public void keyTyped(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyTyped");
    }

    public void changeStarted(GraphicsNodeChangeEvent gnce) {
    }

    public void changeCompleted(GraphicsNodeChangeEvent gnce) {
        if (this.selectionNode == null) {
            return;
        }
        Shape newShape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(this.getSelection(), 1, newShape));
    }

    public void setSelection(Mark begin, Mark end) {
        TextNode node = begin.getTextNode();
        if (node != end.getTextNode()) {
            throw new Error("Markers not from same TextNode");
        }
        node.setSelection(begin, end);
        this.selectionNode = node;
        this.selectionNodeRoot = node.getRoot();
        Object selection = this.getSelection();
        Shape shape = node.getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(selection, 2, shape));
    }

    public void clearSelection() {
        if (this.selectionNode == null) {
            return;
        }
        this.dispatchSelectionEvent(new SelectionEvent(null, 3, null));
        this.selectionNode = null;
        this.selectionNodeRoot = null;
    }

    protected void checkSelectGesture(GraphicsNodeEvent evt) {
        GraphicsNodeMouseEvent mevt = null;
        if (evt instanceof GraphicsNodeMouseEvent) {
            mevt = (GraphicsNodeMouseEvent)evt;
        }
        GraphicsNode source = evt.getGraphicsNode();
        if (this.isDeselectGesture(evt)) {
            if (this.selectionNode != null) {
                this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
            }
            this.clearSelection();
        } else if (mevt != null) {
            Point2D p2 = new Point2D.Double(mevt.getX(), mevt.getY());
            AffineTransform t = source.getGlobalTransform();
            if (t == null) {
                t = new AffineTransform();
            } else {
                try {
                    t = t.createInverse();
                }
                catch (NoninvertibleTransformException ni) {
                    // empty catch block
                }
            }
            p2 = t.transform(p2, null);
            if (source instanceof Selectable && this.isSelectStartGesture(evt)) {
                if (this.selectionNode != source) {
                    if (this.selectionNode != null) {
                        this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
                    }
                    this.selectionNode = source;
                    if (source != null) {
                        this.selectionNodeRoot = source.getRoot();
                        this.selectionNodeRoot.addTreeGraphicsNodeChangeListener(this);
                    }
                }
                ((Selectable)((Object)source)).selectAt(p2.getX(), p2.getY());
                this.dispatchSelectionEvent(new SelectionEvent(null, 4, null));
            } else if (this.isSelectEndGesture(evt)) {
                if (this.selectionNode == source) {
                    ((Selectable)((Object)source)).selectTo(p2.getX(), p2.getY());
                }
                Object oldSelection = this.getSelection();
                if (this.selectionNode != null) {
                    Shape newShape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
                    this.dispatchSelectionEvent(new SelectionEvent(oldSelection, 2, newShape));
                }
            } else if (this.isSelectContinueGesture(evt)) {
                boolean result;
                if (this.selectionNode == source && (result = ((Selectable)((Object)source)).selectTo(p2.getX(), p2.getY()))) {
                    Shape newShape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
                    this.dispatchSelectionEvent(new SelectionEvent(null, 1, newShape));
                }
            } else if (source instanceof Selectable && this.isSelectAllGesture(evt)) {
                if (this.selectionNode != source) {
                    if (this.selectionNode != null) {
                        this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
                    }
                    this.selectionNode = source;
                    if (source != null) {
                        this.selectionNodeRoot = source.getRoot();
                        this.selectionNodeRoot.addTreeGraphicsNodeChangeListener(this);
                    }
                }
                ((Selectable)((Object)source)).selectAll(p2.getX(), p2.getY());
                Object oldSelection = this.getSelection();
                Shape newShape = ((Selectable)((Object)source)).getHighlightShape();
                this.dispatchSelectionEvent(new SelectionEvent(oldSelection, 2, newShape));
            }
        }
    }

    private boolean isDeselectGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 500 && ((GraphicsNodeMouseEvent)evt).getClickCount() == 1;
    }

    private boolean isSelectStartGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 501;
    }

    private boolean isSelectEndGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 502;
    }

    private boolean isSelectContinueGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 506;
    }

    private boolean isSelectAllGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 500 && ((GraphicsNodeMouseEvent)evt).getClickCount() == 2;
    }

    public Object getSelection() {
        Object value = null;
        if (this.selectionNode instanceof Selectable) {
            value = ((Selectable)((Object)this.selectionNode)).getSelection();
        }
        return value;
    }

    public boolean isEmpty() {
        return this.getSelection() == null;
    }

    public void dispatchSelectionEvent(SelectionEvent e2) {
        if (this.listeners != null) {
            Iterator iter = ((AbstractList)this.listeners).iterator();
            switch (e2.getID()) {
                case 2: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionDone(e2);
                    }
                    break;
                }
                case 1: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionChanged(e2);
                    }
                    break;
                }
                case 3: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionCleared(e2);
                    }
                    break;
                }
                case 4: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionStarted(e2);
                    }
                    break;
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener l2) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l2);
    }

    public void removeSelectionListener(SelectionListener l2) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(l2);
        }
    }

    private void report(GraphicsNodeEvent evt, String message) {
        GraphicsNode source = evt.getGraphicsNode();
        String label = "(non-text node)";
        if (source instanceof TextNode) {
            AttributedCharacterIterator iter = ((TextNode)source).getAttributedCharacterIterator();
            char[] cbuff = new char[iter.getEndIndex()];
            if (cbuff.length > 0) {
                cbuff[0] = iter.first();
            }
            int i2 = 1;
            while (i2 < cbuff.length) {
                cbuff[i2] = iter.next();
                ++i2;
            }
            label = new String(cbuff);
        }
        System.out.println("Mouse " + message + " in " + label);
    }
}

