/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5CalculatingInputStream
extends InputStream {
    private final InputStream is;
    private final MessageDigest md5;
    private final File digestFile;

    public Md5CalculatingInputStream(InputStream is, File digestFile) {
        this.is = is;
        this.digestFile = digestFile;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("MD5 algorithm not found", e2);
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.is.read();
        if (result != -1) {
            this.md5.update((byte)result);
        }
        return result;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int result = this.is.read(b2);
        if (result != -1) {
            this.md5.update(b2, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = this.is.read(b2, off, len);
        if (result != -1) {
            this.md5.update(b2, off, result);
        }
        return result;
    }

    private String getDigest() {
        String hash = new BigInteger(1, this.md5.digest()).toString(16);
        if (hash.length() != 32) {
            String zeros = "00000000000000000000000000000000";
            hash = "00000000000000000000000000000000".substring(0, 32 - hash.length()) + hash;
        }
        return hash;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.digestFile));
        writer.write(this.getDigest());
        writer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public long skip(long n2) throws IOException {
        throw new UnsupportedOperationException("skip() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }
}

