/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.BAMIndexWriter;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;

class TextualBAMIndexWriter
implements BAMIndexWriter {
    protected final int nRef;
    protected final File output;
    private final PrintWriter pw;
    private int count = 0;

    public TextualBAMIndexWriter(int nRef, File output) {
        this.output = output;
        this.nRef = nRef;
        try {
            this.pw = new PrintWriter(output);
        }
        catch (FileNotFoundException e) {
            throw new SAMException("Can't find output file " + output, e);
        }
        this.writeHeader();
    }

    private void writeHeader() {
        this.pw.println("n_ref=" + this.nRef);
    }

    public void writeReference(BAMIndexContent content) {
        int size;
        int reference = content.getReferenceSequence();
        if (content == null) {
            this.writeNullContent(reference);
            ++this.count;
            return;
        }
        if (reference != this.count) {
            throw new SAMException("Reference on content is " + reference + " but expecting reference " + this.count);
        }
        ++this.count;
        BAMIndexContent.BinList bins = content.getBins();
        int n = size = bins == null ? 0 : content.getNumberOfNonNullBins();
        if (size == 0) {
            this.writeNullContent(reference);
            return;
        }
        BAMIndexMetaData metaData = content.getMetaData();
        this.pw.println("Reference " + reference + " has n_bin= " + Integer.toString(size + (metaData != null ? 1 : 0)));
        for (Bin bin : bins) {
            if (bin.getBinNumber() == 37450) break;
            if (bin.getChunkList() == null) {
                this.pw.println("  Ref " + reference + " bin " + bin.getBinNumber() + " has no binArray");
                continue;
            }
            List<Chunk> chunkList = bin.getChunkList();
            if (chunkList == null) {
                this.pw.println("  Ref " + reference + " bin " + bin.getBinNumber() + " has no chunkList");
                continue;
            }
            this.pw.print("  Ref " + reference + " bin " + bin.getBinNumber() + " has n_chunk= " + chunkList.size());
            if (chunkList.size() == 0) {
                this.pw.println();
            }
            for (Chunk c : chunkList) {
                this.pw.println("     Chunk: " + c.toString() + " start: " + Long.toString(c.getChunkStart(), 16) + " end: " + Long.toString(c.getChunkEnd(), 16));
            }
        }
        this.writeChunkMetaData(reference, metaData);
        LinearIndex linearIndex = content.getLinearIndex();
        if (linearIndex == null || linearIndex.getIndexEntries() == null) {
            this.pw.println("Reference " + reference + " has n_intv= 0");
            return;
        }
        long[] entries = linearIndex.getIndexEntries();
        int indexStart = linearIndex.getIndexStart();
        int n_intv = entries.length + indexStart;
        this.pw.println("Reference " + reference + " has n_intv= " + n_intv);
        for (int k = 0; k < entries.length; ++k) {
            if (entries[k] == 0L) continue;
            this.pw.println("  Ref " + reference + " ioffset for " + (k + indexStart) + " is " + Long.toString(entries[k]));
        }
        this.pw.flush();
    }

    private void writeChunkMetaData(int reference, BAMIndexMetaData metaData) {
        int nChunks = metaData == null ? 0 : 2;
        this.pw.print("  Ref " + reference + " bin 37450 has n_chunk= " + nChunks);
        if (nChunks == 0) {
            this.pw.println();
        } else {
            this.pw.println("     Chunk:  start: " + Long.toString(metaData.getFirstOffset(), 16) + " end: " + Long.toString(metaData.getLastOffset(), 16));
            this.pw.println("     Chunk:  start: " + Long.toString(metaData.getAlignedRecordCount(), 16) + " end: " + Long.toString(metaData.getUnalignedRecordCount(), 16));
        }
    }

    private void writeNullContent(int reference) {
        this.pw.println("Reference " + reference + " has n_bin=0");
        this.pw.println("Reference " + reference + " has n_intv=0");
    }

    public void writeNoCoordinateRecordCount(Long noCoordinateCount) {
        this.pw.println("No Coordinate Count=" + noCoordinateCount);
    }

    public void close() {
        this.pw.close();
    }
}

