/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.vcf;

public enum VCFHeaderVersion {
    VCF3_2("VCRv3.2", "format"),
    VCF3_3("VCFv3.3", "fileformat"),
    VCF4_0("VCFv4.0", "fileformat"),
    VCF4_1("VCFv4.1", "fileformat");

    private final String versionString;
    private final String formatString;

    private VCFHeaderVersion(String vString, String fString) {
        this.versionString = vString;
        this.formatString = fString;
    }

    public static VCFHeaderVersion toHeaderVersion(String version) {
        version = VCFHeaderVersion.clean(version);
        for (VCFHeaderVersion hv : VCFHeaderVersion.values()) {
            if (!hv.versionString.equals(version)) continue;
            return hv;
        }
        return null;
    }

    public static boolean isVersionString(String version) {
        return VCFHeaderVersion.toHeaderVersion(version) != null;
    }

    public static boolean isFormatString(String format) {
        format = VCFHeaderVersion.clean(format);
        for (VCFHeaderVersion hv : VCFHeaderVersion.values()) {
            if (!hv.formatString.equals(format)) continue;
            return true;
        }
        return false;
    }

    private static String clean(String s) {
        return s.trim();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

