/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.VCFConstants;
import org.broad.tribble.vcf.VCFFilterHeaderLine;
import org.broad.tribble.vcf.VCFFormatHeaderLine;
import org.broad.tribble.vcf.VCFHeader;
import org.broad.tribble.vcf.VCFHeaderLine;
import org.broad.tribble.vcf.VCFHeaderLineType;
import org.broad.tribble.vcf.VCFHeaderVersion;
import org.broad.tribble.vcf.VCFInfoHeaderLine;

public class VCFCodec
implements FeatureCodec,
NameAwareCodec {
    private static final Logger log = Logger.getLogger(VCFCodec.class);
    private static final int NUM_STANDARD_FIELDS = 8;
    private VCFHeader header = null;
    private VCFHeaderVersion version = VCFHeaderVersion.VCF4_0;
    private Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    private String[] GTValueArray = new String[100];
    private String[] genotypeKeyArray = new String[100];
    private String[] infoValueArray = new String[1000];
    public static boolean validate = true;
    private String[] parts = null;
    private String[] genotypeParts = null;
    private HashMap<String, LinkedHashSet<String>> filterHash = new HashMap();
    TreeMap<String, VCFHeaderLineType> infoFields = new TreeMap();
    TreeMap<String, VCFHeaderLineType> formatFields = new TreeMap();
    Set<String> filterFields = new HashSet<String>();
    private final boolean validateFromHeader = false;
    private String name = "Unknown";
    private int lineNo = 0;
    private LineTransform transformer = null;
    private Map<String, String> stringCache = new HashMap<String, String>();

    @Override
    public Object readHeader(LineReader reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        try {
            String line;
            boolean foundHeaderVersion = false;
            while ((line = reader.readLine()) != null) {
                ++this.lineNo;
                if (line.startsWith("##")) {
                    String[] lineFields = line.substring(2).split("=");
                    if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                        }
                        foundHeaderVersion = true;
                        this.version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                        if (this.version == VCFHeaderVersion.VCF4_1) {
                            this.version = VCFHeaderVersion.VCF4_0;
                        }
                    }
                    headerStrings.add(line);
                    continue;
                }
                if (line.startsWith("#")) {
                    if (!foundHeaderVersion) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    return this.createHeader(headerStrings, line);
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception ", e);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    public Object createHeader(List<String> headerStrings, String line) {
        headerStrings.add(line);
        this.header = VCFCodec.createHeader(headerStrings, this.version);
        for (VCFHeaderLine hl : this.header.getMetaData()) {
            if (hl instanceof VCFFilterHeaderLine) {
                this.filterFields.add(((VCFFilterHeaderLine)hl).getName());
            }
            if (hl instanceof VCFFormatHeaderLine) {
                this.formatFields.put(((VCFFormatHeaderLine)hl).getName(), ((VCFFormatHeaderLine)hl).getType());
            }
            if (!(hl instanceof VCFInfoHeaderLine)) continue;
            this.infoFields.put(((VCFInfoHeaderLine)hl).getName(), ((VCFInfoHeaderLine)hl).getType());
        }
        return this.header;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.reallyDecode(line);
    }

    public Feature decode(String line) {
        return this.reallyDecode(line);
    }

    private Feature reallyDecode(String line) {
        try {
            if (line.startsWith("#")) {
                return null;
            }
            if (this.header == null) {
                throw new IllegalStateException("VCF Header cannot be null when decoding a record");
            }
            if (this.parts == null) {
                this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
            }
            int nParts = ParsingUtils.split(line, this.parts, '\t', true);
            if ((this.header == null || this.header != null && !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
                throw new IllegalArgumentException("There aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )");
            }
            return this.parseVCFLine(this.parts);
        }
        catch (TribbleException e) {
            throw new TribbleException.InvalidDecodeLine(e.getMessage(), line);
        }
    }

    private Allele oneAllele(String index, List<Allele> alleles) {
        if (index.equals(".")) {
            return Allele.NO_CALL;
        }
        int i = Integer.valueOf(index);
        if (i >= alleles.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + index + " is not defined in the REF/ALT columns in the record");
        }
        return alleles.get(i);
    }

    private List<Allele> parseGenotypeAlleles(String GT, List<Allele> alleles, Map<String, List<Allele>> cache) {
        List<Allele> GTAlleles = cache.get(GT);
        if (GTAlleles == null) {
            StringTokenizer st = new StringTokenizer(GT, "/|\\");
            GTAlleles = new ArrayList<Allele>(st.countTokens());
            while (st.hasMoreTokens()) {
                String genotype = st.nextToken();
                GTAlleles.add(this.oneAllele(genotype, alleles));
            }
            cache.put(GT, GTAlleles);
        }
        return GTAlleles;
    }

    private Map<String, Object> parseInfo(String infoField, String id) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (!infoField.equals(".")) {
            int infoValueSplitSize = ParsingUtils.split(infoField, this.infoValueArray, ';');
            for (int i = 0; i < infoValueSplitSize; ++i) {
                Object value;
                String key;
                int eqI = this.infoValueArray[i].indexOf("=");
                if (eqI != -1) {
                    key = this.infoValueArray[i].substring(0, eqI);
                    String str = this.infoValueArray[i].substring(eqI + 1, this.infoValueArray[i].length());
                    value = str.contains(",") ? Arrays.asList(str.split(",")) : str;
                } else {
                    key = this.infoValueArray[i];
                    value = true;
                }
                attributes.put(key, value);
            }
        }
        this.validateFields(attributes.keySet(), this.infoFields.keySet());
        attributes.put("ID", id);
        return attributes;
    }

    private void validateFields(Set<String> attributes, Set<String> fields) {
    }

    private Double parseQual(String qualString) {
        if (qualString.equals(".")) {
            return -1.0;
        }
        Double val = Double.valueOf(qualString);
        if (val < 0.0 && Math.abs(val - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return -1.0;
        }
        return val / 10.0;
    }

    private List<Allele> parseAlleles(String ref, String alts) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        this.checkAllele(ref, true);
        Allele refAllele = Allele.create(ref, true);
        alleles.add(refAllele);
        if (alts.indexOf(",") == -1) {
            this.parseSingleAltAllele(alleles, alts);
        } else {
            for (String alt : alts.split(",")) {
                this.parseSingleAltAllele(alleles, alt);
            }
        }
        return alleles;
    }

    private void checkAllele(String allele, boolean isRef) {
        if (this.isSymbolicAllele(allele)) {
            if (isRef) {
                this.generateException("Symbolic alleles not allowed as reference allele: " + allele);
            }
        } else {
            if (this.version != VCFHeaderVersion.VCF4_0 && (allele.toUpperCase().charAt(0) == 'D' || allele.toUpperCase().charAt(0) == 'I')) {
                this.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF 4.0 using VCFTools, available at http://vcftools.sourceforge.net/index.html");
            }
            if (!Allele.acceptableAlleleBases(allele)) {
                this.generateException("Unparsable vcf record with allele " + allele);
            }
        }
    }

    private boolean isSymbolicAllele(String allele) {
        return allele != null && allele.startsWith("<") && allele.endsWith(">") && allele.length() > 2;
    }

    private void parseSingleAltAllele(List<Allele> alleles, String alt) {
        this.checkAllele(alt, false);
        Allele allele = Allele.create(alt, false);
        if (!allele.isNoCall()) {
            alleles.add(allele);
        }
    }

    private Set<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        LinkedHashSet<String> fFields = new LinkedHashSet<String>();
        if (this.version == VCFHeaderVersion.VCF4_0) {
            if (filterString.equals("PASS")) {
                return fFields;
            }
            if (filterString.equals("0")) {
                this.generateException("0 is an invalid filter name in vcf4.0");
            }
        } else if (filterString.equals("0")) {
            return fFields;
        }
        if (this.filterHash.containsKey(filterString)) {
            return this.filterHash.get(filterString);
        }
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, fFields);
        this.validateFields(fFields, this.filterFields);
        return fFields;
    }

    private VariantContext parseVCFLine(String[] parts) {
        ++this.lineNo;
        String contig = this.getCachedString(parts[0]);
        long pos = Long.valueOf(parts[1]);
        String id = parts[2].equals(".") ? "." : new String(parts[2]);
        String ref = this.getCachedString(parts[3].toUpperCase());
        String alts = this.getCachedString(parts[4].toUpperCase());
        Double qual = this.parseQual(parts[5]);
        String filter = this.getCachedString(parts[6]);
        String info = new String(parts[7]);
        List<Allele> alleles = this.parseAlleles(ref, alts);
        Set<String> filters = this.parseFilters(filter);
        Map<String, Object> attributes = this.parseInfo(info, id);
        long loc = pos;
        if (alleles.size() == 1) {
            loc = pos + (long)alleles.get(0).length() - 1L;
        } else if (!this.isSingleNucleotideEvent(alleles)) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            loc = VCFCodec.clipAlleles(pos, ref, alleles, newAlleles);
            alleles = newAlleles;
        }
        if (parts.length > 8) {
            attributes.put("_UNPARSED_GENOTYPE_MAP_", new String(parts[8]));
            attributes.put("_UNPARSED_GENOTYPE_PARSER_", this);
        }
        VariantContext vc = null;
        try {
            vc = new VariantContext(this.name, contig, pos, loc, alleles, qual, filters, attributes);
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        return VCFCodec.createVariantContextWithTrimmedAlleles(vc);
    }

    private boolean isSingleNucleotideEvent(List<Allele> alleles) {
        for (Allele a : alleles) {
            if (a.length() == 1) continue;
            return false;
        }
        return true;
    }

    private void generateException(String message) {
        throw new TribbleException.InvalidDecodeLine(message, this.lineNo);
    }

    public Map<String, Genotype> createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        int nParts = ParsingUtils.split(str, this.genotypeParts, '\t');
        LinkedHashMap<String, Genotype> genotypes = new LinkedHashMap<String, Genotype>(nParts);
        int nGTKeys = ParsingUtils.split(this.genotypeParts[0], this.genotypeKeyArray, ':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            int GTValueSplitSize = ParsingUtils.split(this.genotypeParts[genotypeOffset], this.GTValueArray, ':');
            double GTQual = -1.0;
            Set<String> genotypeFilters = null;
            HashMap<String, String> gtAttributes = null;
            String sampleName = sampleNameIterator.next();
            if (nGTKeys < GTValueSplitSize) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (nGTKeys >= 1) {
                gtAttributes = new HashMap<String, String>(nGTKeys - 1);
                for (int i = 0; i < nGTKeys; ++i) {
                    boolean missing;
                    String gtKey = new String(this.genotypeKeyArray[i]);
                    boolean bl = missing = i >= GTValueSplitSize;
                    if (gtKey.equals("GT")) {
                        if (i != 0) {
                            this.generateException("Saw GT at position " + i + ", but it must be at the first position for genotypes");
                        }
                        genotypeAlleleLocation = i;
                        continue;
                    }
                    if (gtKey.equals("GQ")) {
                        GTQual = missing ? this.parseQual(".") : this.parseQual(this.GTValueArray[i]);
                        continue;
                    }
                    if (gtKey.equals("FT")) {
                        genotypeFilters = missing ? this.parseFilters(".") : this.parseFilters(this.getCachedString(this.GTValueArray[i]));
                        continue;
                    }
                    if (missing || this.version != VCFHeaderVersion.VCF4_0 && this.GTValueArray[i].equals("-1")) {
                        gtAttributes.put(gtKey, ".");
                        continue;
                    }
                    gtAttributes.put(gtKey, new String(this.GTValueArray[i]));
                }
                this.validateFields(gtAttributes.keySet(), this.formatFields.keySet());
            }
            if (genotypeAlleleLocation < 0) {
                this.generateException("Unable to find required field GT for the record; we don't yet support a missing GT field");
            }
            boolean phased = this.GTValueArray[genotypeAlleleLocation].length() > 1 && this.GTValueArray[genotypeAlleleLocation].charAt(1) == '|';
            try {
                genotypes.put(sampleName, new Genotype(sampleName, this.parseGenotypeAlleles(this.GTValueArray[genotypeAlleleLocation], alleles, this.alleleMap), GTQual, genotypeFilters, gtAttributes, phased));
                continue;
            }
            catch (TribbleException e) {
                throw new TribbleException.InternalCodecException(e.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return genotypes;
    }

    private static int computeForwardClipping(List<Allele> unclippedAlleles, String ref) {
        boolean clipping = true;
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic() || a.length() >= 1 && a.getBases()[0] == ref.getBytes()[0]) continue;
            clipping = false;
        }
        return clipping ? 1 : 0;
    }

    private static long clipAlleles(long position, String ref, List<Allele> unclippedAlleles, List<Allele> clippedAlleles) {
        int forwardClipping = VCFCodec.computeForwardClipping(unclippedAlleles, ref);
        int reverseClipped = 0;
        boolean clipping = true;
        while (clipping) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) continue;
                if (a.length() - reverseClipped <= forwardClipping || a.length() - forwardClipping == 0) {
                    clipping = false;
                    continue;
                }
                if (a.getBases()[a.length() - reverseClipped - 1] == ref.getBytes()[ref.length() - reverseClipped - 1]) continue;
                clipping = false;
            }
            if (!clipping) continue;
            ++reverseClipped;
        }
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic()) {
                clippedAlleles.add(a);
                continue;
            }
            clippedAlleles.add(Allele.create(Arrays.copyOfRange(a.getBases(), 0, a.getBases().length - reverseClipped), a.isReference()));
        }
        int refLength = ref.length() - reverseClipped;
        return position + (long)Math.max(refLength - 1, 0);
    }

    public static VariantContext createVariantContextWithTrimmedAlleles(VariantContext inputVC) {
        boolean trimVC = true;
        Allele refAllele = inputVC.getReference();
        if (!inputVC.isVariant()) {
            trimVC = false;
        } else if (refAllele.isNull()) {
            trimVC = false;
        } else {
            boolean bl = trimVC = VCFCodec.computeForwardClipping(new ArrayList<Allele>(inputVC.getAlternateAlleles()), inputVC.getReference().getDisplayString()) > 0;
        }
        if (trimVC) {
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            TreeMap<String, Genotype> genotypes = new TreeMap<String, Genotype>();
            Map<String, Genotype> inputGenotypes = inputVC.getGenotypes();
            TreeMap<String, Object> attributes = new TreeMap<String, Object>(inputVC.getAttributes());
            attributes.put("_REFERENCE_BASE_FOR_INDEL_", new Byte(inputVC.getReference().getBases()[0]));
            HashMap<Allele, Allele> originalToTrimmedAlleleMap = new HashMap<Allele, Allele>();
            for (Allele allele : inputVC.getAlleles()) {
                if (allele.isSymbolic()) {
                    alleles.add(allele);
                    originalToTrimmedAlleleMap.put(allele, allele);
                    continue;
                }
                byte[] newBases = Arrays.copyOfRange(allele.getBases(), 1, allele.length());
                Allele trimmedAllele = Allele.create(newBases, allele.isReference());
                alleles.add(trimmedAllele);
                originalToTrimmedAlleleMap.put(allele, trimmedAllele);
            }
            for (Map.Entry entry : inputVC.getGenotypes().entrySet()) {
                List<Allele> originalAlleles = ((Genotype)entry.getValue()).getAlleles();
                ArrayList<Allele> trimmedAlleles = new ArrayList<Allele>();
                for (Allele a : originalAlleles) {
                    if (a.isCalled()) {
                        trimmedAlleles.add((Allele)originalToTrimmedAlleleMap.get(a));
                        continue;
                    }
                    trimmedAlleles.add(Allele.NO_CALL);
                }
                genotypes.put((String)entry.getKey(), Genotype.modifyAlleles((Genotype)entry.getValue(), trimmedAlleles));
            }
            return new VariantContext(inputVC.getSource(), inputVC.getChr(), (long)inputVC.getStart(), (long)inputVC.getEnd(), alleles, genotypes, inputVC.getNegLog10PError(), inputVC.filtersWereApplied() ? inputVC.getFilters() : null, attributes);
        }
        return inputVC;
    }

    public Class getFeatureType() {
        return VariantContext.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public LineTransform getTransformer() {
        return this.transformer;
    }

    public void setTransformer(LineTransform transformer) {
        this.transformer = transformer;
    }

    public static VCFHeader createHeader(List<String> headerStrings, VCFHeaderVersion version) {
        TreeSet<VCFHeaderLine> metaData = new TreeSet<VCFHeaderLine>();
        LinkedHashSet<String> auxTags = new LinkedHashSet<String>();
        for (String str : headerStrings) {
            if (!str.startsWith("##")) {
                String[] strings = str.substring(1).split("\t");
                int arrayIndex = 0;
                for (VCFHeader.HEADER_FIELDS field : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (field != VCFHeader.HEADER_FIELDS.valueOf(strings[arrayIndex])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)field) + "' but we saw '" + strings[arrayIndex] + "'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + strings[arrayIndex] + "'; it does not match a legal column header name.");
                    }
                    ++arrayIndex;
                }
                if (arrayIndex < strings.length) {
                    if (!strings[arrayIndex].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + strings[arrayIndex] + "'");
                    }
                    ++arrayIndex;
                }
                while (arrayIndex < strings.length) {
                    auxTags.add(strings[arrayIndex++]);
                }
                continue;
            }
            if (str.startsWith("##INFO=")) {
                metaData.add(new VCFInfoHeaderLine(str.substring(7), version));
                continue;
            }
            if (str.startsWith("##FILTER=")) {
                metaData.add(new VCFFilterHeaderLine(str.substring(9), version));
                continue;
            }
            if (str.startsWith("##FORMAT=")) {
                metaData.add(new VCFFormatHeaderLine(str.substring(9), version));
                continue;
            }
            int equals = str.indexOf("=");
            if (equals == -1) continue;
            metaData.add(new VCFHeaderLine(str.substring(2, equals), str.substring(equals + 1)));
        }
        return new VCFHeader(metaData, auxTags);
    }

    private String getCachedString(String str) {
        String internedString = this.stringCache.get(str);
        if (internedString == null) {
            internedString = new String(str);
            this.stringCache.put(internedString, internedString);
        }
        return internedString;
    }

    public static interface LineTransform {
        public String lineTransform(String var1);
    }
}

