/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.variantcontext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.GenotypeLikelihoods;
import org.broad.tribble.util.variantcontext.InferredGeneticContext;

public class Genotype {
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    protected InferredGeneticContext commonInfo;
    public static final double NO_NEG_LOG_10PERROR = -1.0;
    protected List<Allele> alleles = null;
    protected boolean isPhased = false;
    private boolean filtersWereAppliedToContext;

    public Genotype(String sampleName, List<Allele> alleles, double negLog10PError, Set<String> filters, Map<String, ?> attributes, boolean isPhased) {
        this.alleles = Collections.unmodifiableList(alleles);
        this.commonInfo = new InferredGeneticContext(sampleName, negLog10PError, filters, attributes);
        this.filtersWereAppliedToContext = filters != null;
        this.isPhased = isPhased;
        this.validate();
    }

    public Genotype(String sampleName, List<Allele> alleles, double negLog10PError) {
        this(sampleName, alleles, negLog10PError, null, null, false);
    }

    public Genotype(String sampleName, List<Allele> alleles) {
        this(sampleName, alleles, -1.0, null, null, false);
    }

    public static Genotype modifyName(Genotype g, String name) {
        return new Genotype(name, g.getAlleles(), g.getNegLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, g.getAttributes(), g.isPhased());
    }

    public static Genotype modifyAttributes(Genotype g, Map<String, Object> attributes) {
        return new Genotype(g.getSampleName(), g.getAlleles(), g.getNegLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, attributes, g.isPhased());
    }

    public static Genotype modifyAlleles(Genotype g, List<Allele> alleles) {
        return new Genotype(g.getSampleName(), alleles, g.getNegLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, g.getAttributes(), g.isPhased());
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<Allele> getAlleles(Allele allele) {
        ArrayList<Allele> al = new ArrayList<Allele>();
        for (Allele a : this.alleles) {
            if (!a.equals(allele)) continue;
            al.add(a);
        }
        return Collections.unmodifiableList(al);
    }

    public Allele getAllele(int i) {
        return this.alleles.get(i);
    }

    public boolean isPhased() {
        return this.isPhased;
    }

    public int getPloidy() {
        return this.alleles.size();
    }

    public Type getType() {
        Allele firstAllele = this.alleles.get(0);
        if (firstAllele.isNoCall()) {
            return Type.NO_CALL;
        }
        for (Allele a : this.alleles) {
            if (firstAllele.equals(a)) continue;
            return Type.HET;
        }
        return firstAllele.isReference() ? Type.HOM_REF : Type.HOM_VAR;
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == Type.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == Type.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == Type.HET;
    }

    public boolean isNoCall() {
        return this.getType() == Type.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != Type.NO_CALL;
    }

    public boolean hasLikelihoods() {
        return this.hasAttribute("PL") && !this.getAttribute("PL").equals(".") || this.hasAttribute("GL") && !this.getAttribute("GL").equals(".");
    }

    public GenotypeLikelihoods getLikelihoods() {
        GenotypeLikelihoods x = this.getLikelihoods("PL", true);
        if (x != null) {
            return x;
        }
        x = this.getLikelihoods("GL", false);
        if (x != null) {
            return x;
        }
        throw new IllegalStateException("BUG: genotype likelihood field in " + this.getSampleName() + " sample are not either a string or a genotype likelihood class!");
    }

    private GenotypeLikelihoods getLikelihoods(String key, boolean asPL) {
        Object x = this.getAttribute(key);
        if (x instanceof String) {
            if (asPL) {
                return GenotypeLikelihoods.fromPLField((String)x);
            }
            return GenotypeLikelihoods.fromGLField((String)x);
        }
        if (x instanceof GenotypeLikelihoods) {
            return (GenotypeLikelihoods)x;
        }
        return null;
    }

    public void validate() {
        if (this.alleles == null) {
            throw new IllegalArgumentException("BUG: alleles cannot be null in setAlleles");
        }
        if (this.alleles.size() == 0) {
            throw new IllegalArgumentException("BUG: alleles cannot be of size 0 in setAlleles");
        }
        int nNoCalls = 0;
        for (Allele allele : this.alleles) {
            if (allele == null) {
                throw new IllegalArgumentException("BUG: allele cannot be null in Genotype");
            }
            nNoCalls += allele.isNoCall() ? 1 : 0;
        }
        if (nNoCalls > 0 && nNoCalls != this.alleles.size()) {
            throw new IllegalArgumentException("BUG: alleles include some No Calls and some Calls, an illegal state " + this);
        }
    }

    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    public String getGenotypeString(boolean ignoreRefState) {
        return ParsingUtils.join(this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR, ignoreRefState ? this.getAlleleStrings() : (this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles())));
    }

    private List<String> getAlleleStrings() {
        ArrayList<String> al = new ArrayList<String>();
        for (Allele a : this.alleles) {
            al.add(a.getBaseString());
        }
        return al;
    }

    public String toString() {
        int Q = (int)Math.round(this.getPhredScaledQual());
        return String.format("[%s %s Q%s %s]", this.getSampleName(), this.getGenotypeString(false), Q == -10 ? "." : String.format("%2d", Q), Genotype.sortedString(this.getAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%.2f", this.getGenotypeString(false), this.getPhredScaledQual());
    }

    public boolean sameGenotype(Genotype other) {
        return this.sameGenotype(other, true);
    }

    public boolean sameGenotype(Genotype other, boolean ignorePhase) {
        if (this.getPloidy() != other.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> thisAlleles = this.getAlleles();
        SequencedCollection<Allele> otherAlleles = other.getAlleles();
        if (ignorePhase) {
            thisAlleles = new TreeSet<Allele>(thisAlleles);
            otherAlleles = new TreeSet<Allele>(otherAlleles);
        }
        return ((Object)thisAlleles).equals(otherAlleles);
    }

    public static <T extends Comparable<T>, V> String sortedString(Map<T, V> c) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k : t) {
            pairs.add(k + "=" + c.get(k));
        }
        return "{" + ParsingUtils.join(", ", pairs.toArray(new String[pairs.size()])) + "}";
    }

    public String getSampleName() {
        return this.commonInfo.getName();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.filtersWereAppliedToContext;
    }

    public boolean hasNegLog10PError() {
        return this.commonInfo.hasNegLog10PError();
    }

    public double getNegLog10PError() {
        return this.commonInfo.getNegLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    public Object getAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    public String getAttributeAsString(String key) {
        return this.commonInfo.getAttributeAsString(key);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return this.commonInfo.getAttributeAsString(key, defaultValue);
    }

    public int getAttributeAsInt(String key) {
        return this.commonInfo.getAttributeAsInt(key);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return this.commonInfo.getAttributeAsInt(key, defaultValue);
    }

    public double getAttributeAsDouble(String key) {
        return this.commonInfo.getAttributeAsDouble(key);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return this.commonInfo.getAttributeAsDouble(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key) {
        return this.commonInfo.getAttributeAsBoolean(key);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return this.commonInfo.getAttributeAsBoolean(key, defaultValue);
    }

    public Integer getAttributeAsIntegerNoException(String key) {
        return this.commonInfo.getAttributeAsIntegerNoException(key);
    }

    public Double getAttributeAsDoubleNoException(String key) {
        return this.commonInfo.getAttributeAsDoubleNoException(key);
    }

    public String getAttributeAsStringNoException(String key) {
        return this.commonInfo.getAttributeAsStringNoException(key);
    }

    public Boolean getAttributeAsBooleanNoException(String key) {
        return this.commonInfo.getAttributeAsBooleanNoException(key);
    }

    public static enum Type {
        NO_CALL,
        HOM_REF,
        HET,
        HOM_VAR;

    }
}

