/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureSource;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.source.query.AsciiQuerySource;
import org.broad.tribble.source.query.IndexFreeAsciiQuerySource;
import org.broad.tribble.source.query.QuerySource;
import org.broad.tribble.source.tabix.TabixLineReader;
import org.broad.tribble.util.HttpUtils;
import org.broad.tribble.util.ParsingUtils;

public class BasicFeatureSource<T extends Feature>
implements FeatureSource<T> {
    private static final Logger log = Logger.getLogger("BasicFeatureSource");
    String path;
    private final QuerySource querySource;
    private final FeatureCodec codec;
    private final Object header;

    public static final BasicFeatureSource getFeatureSource(String featureResource, FeatureCodec codec, boolean requireIndex) throws TribbleException {
        try {
            QuerySource querySource;
            if (!BasicFeatureSource.resourceExists(featureResource)) {
                throw new TribbleException.FeatureFileDoesntExist(featureResource, featureResource);
            }
            if (featureResource.endsWith(".gz")) {
                querySource = new TabixLineReader(featureResource);
            } else {
                String indexFile = Tribble.indexFile(featureResource);
                if (BasicFeatureSource.resourceExists(indexFile)) {
                    querySource = new AsciiQuerySource(featureResource, indexFile);
                } else {
                    if (requireIndex) {
                        throw new FileNotFoundException("A index is requred, but none could be found for " + featureResource);
                    }
                    querySource = new IndexFreeAsciiQuerySource(featureResource);
                }
            }
            return new BasicFeatureSource(querySource, codec, featureResource);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e);
        }
        catch (TribbleException e) {
            e.setSource(featureResource);
            throw e;
        }
    }

    private static boolean resourceExists(String resource) throws MalformedURLException {
        boolean remoteFile = resource.startsWith("http://") || resource.startsWith("https://") || resource.startsWith("ftp://");
        return !remoteFile && new File(resource).exists() || remoteFile && HttpUtils.resourceAvailable(new URL(resource));
    }

    public static final BasicFeatureSource getFeatureSource(String featureFile, FeatureCodec codec) throws TribbleException {
        return BasicFeatureSource.getFeatureSource(featureFile, codec, true);
    }

    public BasicFeatureSource(String featureFile, Index indexInstance, FeatureCodec codec) throws IOException {
        this.path = featureFile;
        this.codec = codec;
        this.querySource = new AsciiQuerySource(featureFile, indexInstance);
        this.header = this.readHeader();
    }

    public BasicFeatureSource(String featureFile, String indexFile, FeatureCodec codec) throws IOException {
        this.path = featureFile;
        this.querySource = new AsciiQuerySource(featureFile, indexFile);
        this.codec = codec;
        this.header = this.readHeader();
    }

    private BasicFeatureSource(QuerySource source, FeatureCodec codec, String path) throws IOException {
        this.path = path;
        this.querySource = source;
        this.codec = codec;
        this.header = this.readHeader();
    }

    private Object readHeader() throws IOException {
        Object header;
        if (this.querySource.markSupported()) {
            this.querySource.mark();
            header = this.codec.readHeader(this.querySource.iterate());
            this.querySource.reset();
        } else {
            AsciiLineReader reader = null;
            try {
                reader = ParsingUtils.openAsciiReader(this.path);
                header = this.codec.readHeader(reader);
            }
            catch (Exception e) {
                throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e.getMessage(), this.path, e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return header;
    }

    @Override
    public Object getHeader() {
        return this.header;
    }

    @Override
    public void close() throws IOException {
        if (this.querySource != null) {
            this.querySource.close();
        }
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        return new IteratorImpl(this, chr, start, end);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new IteratorImpl(this);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.querySource.getSequenceNames();
    }

    public static class IteratorImpl<T extends Feature>
    implements CloseableTribbleIterator {
        private static Logger log = Logger.getLogger("IteratorImpl");
        String chr;
        int start;
        int end;
        T currentRecord;
        final LineReader reader;
        BasicFeatureSource<T> basicFeatureSource;

        IteratorImpl(BasicFeatureSource<T> basicFeatureSource) throws IOException {
            this.basicFeatureSource = basicFeatureSource;
            this.reader = ((BasicFeatureSource)basicFeatureSource).querySource.iterate();
            this.readNextRecord();
        }

        IteratorImpl(BasicFeatureSource<T> basicFeatureSource, String sequence, int start, int end) throws IOException {
            this.basicFeatureSource = basicFeatureSource;
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.reader = ((BasicFeatureSource)basicFeatureSource).querySource.query(this.chr, start, end);
            this.advanceToFirstRecord();
        }

        private void readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && this.reader != null && (nextLine = this.reader.readLine()) != null) {
                Feature f = null;
                try {
                    f = (Feature)((BasicFeatureSource)this.basicFeatureSource).codec.decode(nextLine);
                }
                catch (TribbleException e) {
                    e.setSource(this.basicFeatureSource.path);
                    throw e;
                }
                if (f == null) continue;
                if (this.end > 0 && f.getStart() > this.end || this.chr != null && !this.chr.equals(f.getChr())) break;
                if (f.getEnd() < this.start) continue;
                this.currentRecord = f;
            }
        }

        private void advanceToFirstRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && this.reader != null && (nextLine = this.reader.readLine()) != null) {
                Feature f = ((BasicFeatureSource)this.basicFeatureSource).codec.decodeLoc(nextLine);
                if (f == null) continue;
                if (!f.getChr().equals(this.chr)) {
                    this.currentRecord = null;
                    break;
                }
                if (f.getEnd() < this.start) continue;
                this.currentRecord = ((BasicFeatureSource)this.basicFeatureSource).codec.decode(nextLine);
                break;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null) {
                return this.currentRecord != null;
            }
            return this.currentRecord != null && this.chr.equals(this.currentRecord.getChr()) && this.currentRecord.getStart() <= this.end;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        public void close() {
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }
    }
}

