/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.soapsnp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;

public class SoapSNPCodec
implements FeatureCodec,
NameAwareCodec {
    private String[] parts;
    private String name = "Unknown";
    private static final Map<Character, String> IUPAC_SNPS = new HashMap<Character, String>();

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        try {
            this.parts = line.trim().split("\\s+");
            if (this.parts.length != 18) {
                throw new CodecLineParsingException("Invalid SoapSNP row found -- incorrect element count.  Expected 18, got " + this.parts.length + " line = " + line);
            }
            String contig = this.parts[0];
            long start = Long.valueOf(this.parts[1]);
            AlleleAndGenotype allelesAndGenotype = this.parseAlleles(this.parts[2], this.parts[3], line);
            double negLog10PError = (double)Integer.valueOf(this.parts[4]).intValue() / 10.0;
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("BestBaseQ", this.parts[6]);
            attributes.put("SecondBestBaseQ", this.parts[10]);
            attributes.put("RankSumP", this.parts[15]);
            VariantContext vc = new VariantContext(this.name, contig, start, start, allelesAndGenotype.alleles, allelesAndGenotype.genotype, negLog10PError, VariantContext.PASSES_FILTERS, attributes);
            return vc;
        }
        catch (CodecLineParsingException e) {
            throw new TribbleException("Unable to parse line " + line, e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new TribbleException("Unable to parse line " + line, e);
        }
    }

    private AlleleAndGenotype parseAlleles(String ref, String consensusGenotype, String line) {
        if (ref.equals(consensusGenotype)) {
            throw new TribbleException.InternalCodecException("Ref base and consensus genotype are the same " + ref);
        }
        Allele refAllele = Allele.create(ref, true);
        List<Allele> genotypeAlleles = null;
        char base = consensusGenotype.charAt(0);
        switch (base) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': {
                Allele a = Allele.create(consensusGenotype);
                genotypeAlleles = Arrays.asList(a, a);
                break;
            }
            case 'K': 
            case 'M': 
            case 'R': 
            case 'S': 
            case 'W': 
            case 'Y': {
                genotypeAlleles = this.determineAlt(refAllele, ref.charAt(0), base);
                break;
            }
            default: {
                throw new TribbleException("Unexpected consensus genotype " + consensusGenotype + " at line = " + line);
            }
        }
        HashSet<Allele> alleles = new HashSet<Allele>(genotypeAlleles);
        alleles.add(refAllele);
        Genotype genotype = new Genotype("unknown", genotypeAlleles);
        return new AlleleAndGenotype(alleles, genotype);
    }

    private List<Allele> determineAlt(Allele ref, char refbase, char alt) {
        String alts = IUPAC_SNPS.get(Character.valueOf(alt));
        if (alts == null) {
            throw new IllegalStateException("BUG: unexpected consensus genotype " + alt);
        }
        Allele a1 = alts.charAt(0) == refbase ? ref : Allele.create((byte)alts.charAt(0));
        Allele a2 = alts.charAt(1) == refbase ? ref : Allele.create((byte)alts.charAt(1));
        return Arrays.asList(a1, a2);
    }

    public Class getFeatureType() {
        return VariantContext.class;
    }

    @Override
    public Object readHeader(LineReader reader) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static void main(String[] args) {
        System.out.printf("Testing " + args[0], new Object[0]);
    }

    static {
        IUPAC_SNPS.put(Character.valueOf('R'), "AG");
        IUPAC_SNPS.put(Character.valueOf('Y'), "CT");
        IUPAC_SNPS.put(Character.valueOf('S'), "GC");
        IUPAC_SNPS.put(Character.valueOf('W'), "AT");
        IUPAC_SNPS.put(Character.valueOf('K'), "GT");
        IUPAC_SNPS.put(Character.valueOf('M'), "AC");
    }

    private static class AlleleAndGenotype {
        Collection<Allele> alleles;
        Collection<Genotype> genotype;

        public AlleleAndGenotype(Collection<Allele> alleles, Genotype genotype) {
            this.alleles = alleles;
            this.genotype = new HashSet<Genotype>();
            this.genotype.add(genotype);
        }
    }
}

