/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.bed;

import java.awt.Color;
import org.broad.tribble.AbstractFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.bed.BEDFeature;
import org.broad.tribble.bed.FullBEDFeature;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;

public class BEDCodec
extends AbstractFeatureCodec {
    static String[] tokens = new String[15];

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public BEDFeature decode(String line) {
        int start;
        if (line.trim().length() == 0 || line.startsWith("#") || line.startsWith("track") || line.startsWith("browser")) {
            return null;
        }
        int tokenCount = ParsingUtils.splitWhitespace(line, tokens);
        if (tokenCount < 2) {
            return null;
        }
        String chr = tokens[0];
        int end = start = Integer.parseInt(tokens[1]) + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        FullBEDFeature feature = new FullBEDFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[3].replaceAll("\"", "");
            feature.setName(name);
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 8) {
            String colorString = tokens[8];
            feature.setColor(this.parseColor(colorString));
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, chr, feature.getStrand());
        }
        return feature;
    }

    public Class getFeatureType() {
        return BEDFeature.class;
    }

    @Override
    public Object readHeader(LineReader reader) {
        return null;
    }

    private void createExons(int start, String[] tokens, FullBEDFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]) + 1;
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonStart = start + Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i]) - 1;
                gene.addExon(exonStart, exonEnd, cdStart, cdEnd, exonNumber);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }

    private Color parseColor(String colorString) {
        String[] rgb = new String[3];
        int nTokens = ParsingUtils.split(tokens[8].replaceAll("\"", ""), rgb, ',');
        try {
            if (nTokens < 3) {
                return new Color(Integer.parseInt(rgb[0]));
            }
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

