/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;

public class IntArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final int[] EMPTY_ARRAY = new int[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private IntArrays() {
    }

    public static int[] ensureCapacity(int[] array, int length) {
        if (length > array.length) {
            int[] t = new int[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int length, int preserve) {
        if (length > array.length) {
            int[] t = new int[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static int[] grow(int[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            int[] t = new int[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static int[] grow(int[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            int[] t = new int[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static int[] trim(int[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        int[] t = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static int[] setLength(int[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return IntArrays.trim(array, length);
        }
        return IntArrays.ensureCapacity(array, length);
    }

    public static int[] copy(int[] array, int offset, int length) {
        IntArrays.ensureOffsetLength(array, offset, length);
        int[] a = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static int[] copy(int[] array) {
        return (int[])array.clone();
    }

    public static void fill(int[] array, int value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int from, int to, int value) {
        IntArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(int[] a1, int[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(int[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(int[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            IntArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(int[] x, int from, int to, IntComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    IntArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = IntArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = IntArrays.med3(x, m - s, m, m + s, comp);
                n = IntArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = IntArrays.med3(x, l, m, n, comp);
        }
        int v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        IntArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        IntArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            IntArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(int[] x, IntComparator comp) {
        IntArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(int[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(int[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && x[j] < x[j - 1]; --j) {
                    IntArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = IntArrays.med3(x, l, l + s, l + 2 * s);
                m = IntArrays.med3(x, m - s, m, m + s);
                n = IntArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = IntArrays.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        IntArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        IntArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            IntArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(int[] x) {
        IntArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(int[] a, int from, int to, int[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && a[j] < a[j - 1]; --j) {
                    IntArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, a);
        IntArrays.mergeSort(supp, mid, to, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(int[] a, int from, int to) {
        IntArrays.mergeSort(a, from, to, (int[])a.clone());
    }

    public static void mergeSort(int[] a) {
        IntArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(int[] a, int from, int to, IntComparator comp, int[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(a[j - 1], a[j]) > 0; --j) {
                    IntArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, comp, a);
        IntArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(int[] a, int from, int to, IntComparator comp) {
        IntArrays.mergeSort(a, from, to, comp, (int[])a.clone());
    }

    public static void mergeSort(int[] a, IntComparator comp) {
        IntArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(int[] a, int from, int to, int key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a, int key) {
        return IntArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(int[] a, int from, int to, int key, IntComparator c) {
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a, int key, IntComparator c) {
        return IntArrays.binarySearch(a, 0, a.length, key, c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(int[] a, int[] b) {
            return IntArrays.equals(a, b);
        }
    }
}

