/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.modes;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import edu.cornell.med.icb.goby.GobyVersion;
import edu.cornell.med.icb.goby.alignments.AlignmentReaderImpl;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.alignments.ReferenceLocation;
import edu.cornell.med.icb.goby.alignments.UpgradeTo1_9_6;
import edu.cornell.med.icb.goby.modes.AbstractCommandLineMode;
import edu.cornell.med.icb.goby.modes.AbstractGobyMode;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import org.apache.log4j.Level;

public class UpgradeMode
extends AbstractGobyMode {
    private static final String MODE_NAME = "upgrade";
    private static final String MODE_DESCRIPTION = "Upgrade goby files to a new version of Goby. We try to devise Goby format to avoid upgrade steps, but sometimes upgrading the data structures cannot be avoided. This tool converts data structures to the latest Goby format.";
    private String[] basenames;
    private boolean silent;
    private boolean check;

    @Override
    public String getModeName() {
        return MODE_NAME;
    }

    @Override
    public String getModeDescription() {
        return MODE_DESCRIPTION;
    }

    @Override
    public AbstractCommandLineMode configure(String[] args) throws IOException, JSAPException {
        JSAPResult jsapResult = this.parseJsapArguments(args);
        String[] inputFiles = jsapResult.getStringArray("input");
        this.basenames = AlignmentReaderImpl.getBasenames(inputFiles);
        return this;
    }

    @Override
    public void execute() throws IOException {
        for (String basename : this.basenames) {
            this.upgrade(basename);
            if (!this.check) continue;
            this.check(basename);
        }
    }

    public void upgrade(String basename) {
        try {
            AlignmentReaderImpl reader = new AlignmentReaderImpl(basename, false);
            reader.readHeader();
            String version = reader.getGobyVersion();
            if (!this.silent) {
                System.out.printf("processing %s with version %s %n", basename, version);
            }
            if (GobyVersion.isOlder(version, "goby_1.9.6") && reader.isIndexed()) {
                UpgradeTo1_9_6 upgrader = new UpgradeTo1_9_6();
                upgrader.setSilent(this.silent);
                upgrader.upgrade(basename, reader);
            }
        }
        catch (IOException e) {
            System.err.println("Could not read alignment " + basename);
            e.printStackTrace();
        }
    }

    public void check(String basename) {
        try {
            AlignmentReaderImpl reader = new AlignmentReaderImpl(basename, false);
            reader.readHeader();
            String version = reader.getGobyVersion();
            if (!this.silent) {
                System.out.printf("processing %s with version %s %n", basename, version);
            }
            if (GobyVersion.isMoreRecent(version, "1.9.6") && reader.isIndexed()) {
                ObjectList<ReferenceLocation> locations = reader.getLocations(1000);
                System.out.println("Checking..");
                ProgressLogger progress = new ProgressLogger();
                progress.expectedUpdates = locations.size();
                progress.priority = Level.INFO;
                progress.start();
                for (ReferenceLocation location : locations) {
                    Alignments.AlignmentEntry entry = reader.skipTo(location.targetIndex, location.position);
                    if (entry == null) {
                        System.err.printf("Entry must be found at position (t=%d,p=%d) %n", location.targetIndex, location.position);
                        System.exit(1);
                    }
                    if (entry.getTargetIndex() < location.targetIndex) {
                        System.err.printf("Entry must be found on reference >%d for position (t=%d,p=%d) %n", location.targetIndex, location.targetIndex, location.position);
                        System.exit(1);
                    }
                    if (entry.getPosition() < location.position) {
                        System.err.printf("Entry must be found at position >=%d for position (t=%d,p=%d) %n", location.position, entry.getTargetIndex(), entry.getPosition());
                        System.exit(1);
                    }
                    progress.lightUpdate();
                }
                progress.stop();
                System.out.printf("Checked %d skipTo calls", locations.size());
            }
        }
        catch (IOException e) {
            System.err.println("Could not read alignment " + basename);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws JSAPException, IOException {
        new UpgradeMode().configure(args).execute();
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

