/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class VCF3Codec
extends AbstractVCFCodec {
    @Override
    public Object readHeader(LineReader reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        try {
            String line;
            boolean foundHeaderVersion = false;
            while ((line = reader.readLine()) != null) {
                ++this.lineNo;
                if (line.startsWith("##")) {
                    String[] lineFields = line.substring(2).split("=");
                    if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                        }
                        foundHeaderVersion = true;
                        this.version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                        if (this.version != VCFHeaderVersion.VCF3_3 && this.version != VCFHeaderVersion.VCF3_2) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv3 and does not support " + lineFields[1]);
                        }
                    }
                    headerStrings.add(line);
                    continue;
                }
                if (line.startsWith("#")) {
                    if (!foundHeaderVersion) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    return this.createHeader(headerStrings, line);
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception ", e);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected Set<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        LinkedHashSet<String> fFields = new LinkedHashSet<String>();
        if (filterString.equals("0")) {
            return fFields;
        }
        if (filterString.length() == 0) {
            this.generateException("The VCF specification requires a valid filter status");
        }
        if (this.filterHash.containsKey(filterString)) {
            return (Set)this.filterHash.get(filterString);
        }
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, fFields);
        return fFields;
    }

    @Override
    public Map<String, Genotype> createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        int nParts = ParsingUtils.split((String)str, (String[])this.genotypeParts, (char)'\t');
        LinkedHashMap<String, Genotype> genotypes = new LinkedHashMap<String, Genotype>(nParts);
        int nGTKeys = ParsingUtils.split((String)this.genotypeParts[0], (String[])this.genotypeKeyArray, (char)':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            int GTValueSplitSize = ParsingUtils.split((String)this.genotypeParts[genotypeOffset], (String[])this.GTValueArray, (char)':');
            double GTQual = -1.0;
            Set<String> genotypeFilters = null;
            HashMap<String, String> gtAttributes = null;
            String sampleName = sampleNameIterator.next();
            if (nGTKeys < GTValueSplitSize) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (nGTKeys >= 1) {
                gtAttributes = new HashMap<String, String>(nGTKeys - 1);
                for (int i = 0; i < nGTKeys; ++i) {
                    boolean missing;
                    String gtKey = new String(this.genotypeKeyArray[i]);
                    boolean bl = missing = i >= GTValueSplitSize;
                    if (gtKey.equals("GT")) {
                        genotypeAlleleLocation = i;
                        continue;
                    }
                    if (gtKey.equals("GQ")) {
                        GTQual = missing ? VCF3Codec.parseQual(".") : VCF3Codec.parseQual(this.GTValueArray[i]);
                        continue;
                    }
                    if (gtKey.equals("FT")) {
                        genotypeFilters = missing ? this.parseFilters(".") : this.parseFilters(this.getCachedString(this.GTValueArray[i]));
                        continue;
                    }
                    if (missing || this.GTValueArray[i].equals("-1")) {
                        gtAttributes.put(gtKey, ".");
                        continue;
                    }
                    gtAttributes.put(gtKey, new String(this.GTValueArray[i]));
                }
            }
            if (genotypeAlleleLocation < 0) {
                this.generateException("Unable to find the GT field for the record; the GT field is required");
            }
            if (genotypeAlleleLocation > 0) {
                this.generateException("Saw GT field at position " + genotypeAlleleLocation + ", but it must be at the first position for genotypes");
            }
            boolean phased = this.GTValueArray[genotypeAlleleLocation].indexOf("|") != -1;
            try {
                genotypes.put(sampleName, new Genotype(sampleName, VCF3Codec.parseGenotypeAlleles(this.GTValueArray[genotypeAlleleLocation], alleles, this.alleleMap), GTQual, genotypeFilters, gtAttributes, phased));
                continue;
            }
            catch (TribbleException e) {
                throw new TribbleException.InternalCodecException(e.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return genotypes;
    }
}

