/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.metal.MetalMenuUI;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class MetalJideSplitButtonUI
extends MetalMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    private int _splitButtonMargin = 12;
    private int _splitButtonMarginOnMenu = 18;
    protected PropertyChangeListener _propertyChangeListener;
    private FocusListener _focusListener;

    protected String getPropertyPrefix() {
        return "JideSplitButton";
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalJideSplitButtonUI();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createSplitButtonPropertyChangeListener(this.menuItem);
        }
        if (this._propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this._propertyChangeListener);
        }
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this._propertyChangeListener);
        }
        this._propertyChangeListener = null;
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
        this._focusListener = null;
    }

    protected PropertyChangeListener createSplitButtonPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n, JComponent jComponent) {
        MetalJideSplitButtonUI metalJideSplitButtonUI;
        if (n == 0 && (metalJideSplitButtonUI = (MetalJideSplitButtonUI)MetalJideSplitButtonUI.getUIOfType(((JideSplitButton)jComponent).getUI(), MetalJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(metalJideSplitButtonUI.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem jMenuItem = this.menuItem;
        LazyActionMap.installLazyActionMap(jMenuItem, MetalJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jMenuItem);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, inputMap);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem jMenuItem = this.menuItem;
        SwingUtilities.replaceUIInputMap(jMenuItem, 2, null);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, null);
        SwingUtilities.replaceUIActionMap(jMenuItem, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            if (jMenuItem.isEnabled()) {
                if (buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                    graphics.setColor(this.selectionForeground);
                    graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                    graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
            }
            return;
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
        }
        JideSplitButton jideSplitButton = (JideSplitButton)jMenuItem;
        if (jMenuItem instanceof ButtonStyle && ((ButtonStyle)((Object)jMenuItem)).getButtonStyle() == 0) {
            if (jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jMenuItem, graphics, new Rectangle(0, 0, n, n2), JideSwingUtilities.getOrientationOf(jMenuItem), 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 1);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 1);
                    }
                } else {
                    Rectangle rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 3);
                }
            } else if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jMenuItem)) {
                    Rectangle rectangle = new Rectangle(0, 0, n, n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                } else {
                    Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                    }
                    rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                }
            }
        } else if (jMenuItem instanceof ButtonStyle && ((ButtonStyle)((Object)jMenuItem)).getButtonStyle() == 2) {
            if (jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jMenuItem, graphics, new Rectangle(0, 0, n, n2), JideSwingUtilities.getOrientationOf(jMenuItem), 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    this.paintSunkenBorder(graphics, rectangle);
                    rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                        rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle = null;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                    }
                }
            } else if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin - this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                this.paintRaisedBorder(graphics, rectangle);
                rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.paintRaisedBorder(graphics, rectangle);
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
            }
        } else if (jMenuItem instanceof ButtonStyle && ((ButtonStyle)((Object)jMenuItem)).getButtonStyle() == 1) {
            if (jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jMenuItem, graphics, new Rectangle(0, 0, n, n2), JideSwingUtilities.getOrientationOf(jMenuItem), 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 1);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    this.paintSunken2Border(graphics, rectangle);
                    rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if (this.isMouseOver() && buttonModel.isEnabled()) {
                    Rectangle rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 1);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle = null;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                        this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
                    }
                    rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 3);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                }
            } else if (this.isMouseOver() && buttonModel.isEnabled()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin - this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
                rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                this.paintRaised2Border(graphics, rectangle);
                rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.paintRaised2Border(graphics, rectangle);
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                if (((JideSplitButton)jMenuItem).isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
                }
                rectangle = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.getPainter().paintButtonBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0);
            } else {
                Rectangle rectangle = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
                this.paintRaisedBorder(graphics, rectangle);
                rectangle = new Rectangle(n - this._splitButtonMargin + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
                this.paintRaisedBorder(graphics, rectangle);
            }
        }
        if (jMenuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n - 10, n2 / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n - 10, n2 / 2 - 1, 5, 0);
        }
    }

    private void paintSunkenBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintSunken2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.x, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintRaised2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintRaisedBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled() || !((JideSplitButton)jMenuItem).isButtonEnabled()) {
            if (UIDefaultsLookup.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIDefaultsLookup.getColor("MenuItem.disabledForeground"));
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMinimumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        int n = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        dimension.width += n;
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getPreferredSize(jComponent);
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, this.defaultTextIconGap);
        int n = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        dimension.width += n;
        if (bl) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        int n;
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMaximumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        int n2 = n = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        if (bl) {
            dimension.width += n;
        } else {
            dimension.height += n;
        }
        return dimension;
    }

    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                graphics.translate(0, jMenuItem.getWidth() - 1);
                ((Graphics2D)graphics).rotate(-1.5707963267948966);
            }
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(jMenuItem, icon);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, MetalJideSplitButtonUI.iconRect.x, MetalJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                ((Graphics2D)graphics).rotate(1.5707963267948966);
                graphics.translate(0, -jMenuItem.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JideSplitButton) {
            return ((JideSplitButton)jMenuItem).isAlwaysDropdown();
        }
        return false;
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
        lazyActionMap.put(new Actions("downPressed"));
        lazyActionMap.put(new Actions("downReleased"));
    }

    protected static void downButtonPressed(JMenu jMenu) {
        Object object;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (jMenu.isTopLevelMenu()) {
            if (jMenu.isSelected()) {
                menuSelectionManager.clearSelectedPath();
            } else {
                object = jMenu.getParent();
                if (object != null && object instanceof MenuElement) {
                    ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                    while (object instanceof MenuElement) {
                        arrayList.add(0, (MenuElement[])object);
                        object = object.getParent();
                    }
                    MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Container container = (Container)arrayList.get(i);
                        menuElementArray[i] = (MenuElement)((Object)container);
                    }
                    menuElementArray[arrayList.size()] = jMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
        if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu() && (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0)) {
            MetalJideSplitButtonUI.appendPath(object, jMenu.getPopupMenu());
        }
    }

    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("buttonStyle")) {
                AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
                abstractButton.repaint();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string) && ((JideSplitButton)abstractButton).isAlwaysDropdown()) {
                string = DOWN_PRESS;
            }
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (DOWN_PRESS.equals(string)) {
                MetalJideSplitButtonUI.downButtonPressed((JMenu)abstractButton);
            } else if (DOWN_RELEASE.equals(string)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.cancelMenuIfNecessary(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MetalJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu)) {
                if (((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    jMenu.getModel().setArmed(true);
                    jMenu.getModel().setPressed(true);
                }
                if (!jMenu.hasFocus() && jMenu.isRequestFocusEnabled()) {
                    jMenu.requestFocus();
                }
            } else {
                MetalJideSplitButtonUI.downButtonPressed(jMenu);
            }
        }

        private boolean isClickOnButton(MouseEvent mouseEvent, JMenu jMenu) {
            int n;
            if (((JideSplitButton)jMenu).isAlwaysDropdown()) {
                return false;
            }
            boolean bl = false;
            int n2 = n = ((JMenu)MetalJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? MetalJideSplitButtonUI.this._splitButtonMargin : MetalJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(MetalJideSplitButtonUI.this.menuItem) == 0) {
                if (mouseEvent.getPoint().getX() < (double)(jMenu.getWidth() - n)) {
                    bl = true;
                }
            } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n)) {
                bl = true;
            }
            return bl;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(mouseEvent, jMenu)) {
                MetalJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                MetalJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(mouseEvent);
        }

        private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu) && ((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    jMenu.getModel().setPressed(false);
                    jMenu.getModel().setArmed(false);
                } else {
                    jMenu.getModel().setArmed(false);
                    jMenu.getModel().setPressed(false);
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i = menuElementArray.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElementArray[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(jMenu)) continue;
                    jMenu.getModel().setRollover(false);
                    MetalJideSplitButtonUI.this.setMouseOver(false);
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        MetalMenuUI.appendPath(MetalJideSplitButtonUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(MetalJideSplitButtonUI.this.getPath());
                        MetalJideSplitButtonUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MetalJideSplitButtonUI.this.setMouseOver(true);
            }
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MetalJideSplitButtonUI.this.setMouseOver(false);
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

