/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat _numberFormat;
    private static boolean _groupingUsed = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    public String toString(Object object, ConverterContext converterContext) {
        try {
            if (converterContext == null || converterContext.getUserObject() == null || !(converterContext.getUserObject() instanceof NumberFormat)) {
                if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                    return "";
                }
                return this.getNumberFormat().format(object);
            }
            NumberFormat numberFormat = (NumberFormat)converterContext.getUserObject();
            return numberFormat.format(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = DecimalFormat.getInstance();
        }
        this._numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        return this._numberFormat;
    }

    protected NumberFormat getDefaultNumberFormat() {
        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        return numberFormat;
    }

    protected Number parseNumber(String string) {
        Number number;
        try {
            number = this.getNumberFormat().parse(string);
        }
        catch (ParseException parseException) {
            try {
                number = this.getDefaultNumberFormat().parse(string);
            }
            catch (ParseException parseException2) {
                number = null;
            }
        }
        return number;
    }

    public static boolean isGroupingUsed() {
        return _groupingUsed;
    }

    public static void setGroupingUsed(boolean bl) {
        _groupingUsed = bl;
    }
}

