/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.counts;

import edu.cornell.med.icb.goby.counts.CountsReaderI;
import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;
import java.io.InputStream;

public class CountsReader
implements CountsReaderI {
    private final InputBitStream input;
    protected static final int END_OF_DATA_MARKER = 277492431;
    private boolean endOfStream;
    private int deltaCount;
    private int currentCount;
    private int length = -1;
    private boolean nextTransitionLoaded;
    private int count;
    private int position = -1;

    @Override
    public int getPosition() {
        return this.position;
    }

    public CountsReader(InputStream inputStream) throws IOException {
        this.input = new InputBitStream(inputStream);
        this.count = this.currentCount = this.input.readDelta() - 1;
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        int decodedDeltaCount;
        if (this.nextTransitionLoaded) {
            return true;
        }
        if (this.endOfStream) {
            return false;
        }
        int deltaCount = this.input.readGamma();
        if (deltaCount == 277492431) {
            this.endOfStream = true;
            return false;
        }
        this.position += Math.max(1, this.length);
        this.length = this.input.readGamma();
        this.deltaCount = decodedDeltaCount = CountsReader.decodeDeltaCount(deltaCount);
        this.count += decodedDeltaCount;
        this.nextTransitionLoaded = true;
        return true;
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new IllegalStateException("next cannot be called when hasNext would return false.");
        }
        this.nextTransitionLoaded = false;
    }

    public int getDeltaCount() {
        return this.deltaCount;
    }

    public boolean hasNextPosition() throws IOException {
        if (this.length > 0) {
            return true;
        }
        if (this.endOfStream) {
            return false;
        }
        int deltaCount = this.input.readGamma();
        if (deltaCount == 277492431) {
            this.endOfStream = true;
            return false;
        }
        this.length = this.input.readGamma();
        int decodedDeltaCount = CountsReader.decodeDeltaCount(deltaCount);
        this.currentCount += decodedDeltaCount;
        return true;
    }

    public int nextCountAtPosition() throws IOException {
        if (this.hasNextPosition()) {
            --this.length;
            ++this.position;
            return this.currentCount;
        }
        throw new IllegalStateException("next cannot be called when hasNext would return false.");
    }

    protected static int decodeDeltaCount(int deltaCount) {
        if (deltaCount % 2 == 1) {
            return -((deltaCount - 1) / 2);
        }
        return deltaCount / 2;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void skipTo(int position) throws IOException {
        while (this.hasNextTransition()) {
            this.nextTransition();
            if (this.getPosition() < position) continue;
            break;
        }
    }
}

