/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingCollection<T>
implements Iterable<T> {
    private final File tmpDir;
    private final Codec<T> codec;
    private final Comparator<T> comparator;
    private final int maxRecordsInRam;
    private int numRecordsInRam = 0;
    private T[] ramRecords;
    private boolean iterationStarted = false;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();

    private SortingCollection(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRam, File tmpDir) {
        if (maxRecordsInRam <= 0) {
            throw new IllegalArgumentException("maxRecordsInRam must be > 0");
        }
        this.tmpDir = tmpDir;
        this.codec = codec;
        this.comparator = comparator;
        this.maxRecordsInRam = maxRecordsInRam;
        this.ramRecords = (Object[])Array.newInstance(componentType, maxRecordsInRam);
    }

    public void add(T rec) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAdding()");
        }
        if (this.iterationStarted) {
            throw new IllegalStateException("Cannot add after calling iterator()");
        }
        if (this.numRecordsInRam == this.maxRecordsInRam) {
            this.spillToDisk();
        }
        this.ramRecords[this.numRecordsInRam++] = rec;
    }

    public void doneAdding() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call doneAdding() after cleanup() was called.");
        }
        if (this.doneAdding) {
            return;
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            return;
        }
        if (this.numRecordsInRam > 0) {
            this.spillToDisk();
        }
        this.ramRecords = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillToDisk() {
        try {
            Arrays.sort(this.ramRecords, 0, this.numRecordsInRam, this.comparator);
            File f = File.createTempFile("sortingcollection.", ".tmp", this.tmpDir);
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(f));
                this.codec.setOutputStream(os);
                f.deleteOnExit();
                for (int i = 0; i < this.numRecordsInRam; ++i) {
                    this.codec.encode(this.ramRecords[i]);
                    this.ramRecords[i] = null;
                }
                os.flush();
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
            this.numRecordsInRam = 0;
            this.files.add(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public CloseableIterator<T> iterator() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call iterator() after cleanup() was called.");
        }
        this.doneAdding();
        this.iterationStarted = true;
        if (this.files.isEmpty()) {
            return new InMemoryIterator();
        }
        return new MergingIterator();
    }

    public void cleanup() {
        this.iterationStarted = true;
        this.cleanedUp = true;
        IOUtil.deleteFiles(this.files);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, File tmpDir) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, tmpDir);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, tmpDir);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PeekFileRecordIteratorComparator
    implements Comparator<PeekFileRecordIterator> {
        PeekFileRecordIteratorComparator() {
        }

        @Override
        public int compare(PeekFileRecordIterator peekFileRecordIterator, PeekFileRecordIterator peekFileRecordIterator1) {
            return SortingCollection.this.comparator.compare(peekFileRecordIterator.peek(), peekFileRecordIterator1.peek());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PeekFileRecordIterator
    extends PeekIterator<T> {
        PeekFileRecordIterator(Iterator<T> underlyingIterator) {
            super(underlyingIterator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileRecordIterator
    implements CloseableIterator<T> {
        private final File file;
        private final FileInputStream is;
        private final Codec<T> codec;
        private T currentRecord = null;

        FileRecordIterator(File file) {
            this.file = file;
            try {
                this.is = new FileInputStream(file);
                this.codec = SortingCollection.this.codec.clone();
                this.codec.setInputStream(new BufferedInputStream(this.is));
                this.advance();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentRecord;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.currentRecord = this.codec.decode();
        }

        @Override
        public void close() {
            CloserUtil.close(this.is);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MergingIterator
    implements CloseableIterator<T> {
        private final PriorityQueue<PeekFileRecordIterator> priorityQueue;

        MergingIterator() {
            this.priorityQueue = new PriorityQueue<PeekFileRecordIterator>(SortingCollection.this.files.size(), new PeekFileRecordIteratorComparator());
            for (File f : SortingCollection.this.files) {
                FileRecordIterator it = new FileRecordIterator(f);
                if (it.hasNext()) {
                    this.priorityQueue.offer(new PeekFileRecordIterator(it));
                    continue;
                }
                it.close();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.priorityQueue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PeekFileRecordIterator fileIterator = this.priorityQueue.poll();
            Object ret = fileIterator.next();
            if (fileIterator.hasNext()) {
                this.priorityQueue.offer(fileIterator);
            } else {
                ((CloseableIterator)fileIterator.getUnderlyingIterator()).close();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            while (!this.priorityQueue.isEmpty()) {
                PeekFileRecordIterator it = this.priorityQueue.poll();
                ((CloseableIterator)it.getUnderlyingIterator()).close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InMemoryIterator
    implements CloseableIterator<T> {
        private int iterationIndex = 0;

        InMemoryIterator() {
            Arrays.sort(SortingCollection.this.ramRecords, 0, SortingCollection.this.numRecordsInRam, SortingCollection.this.comparator);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterationIndex < SortingCollection.this.numRecordsInRam;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return SortingCollection.this.ramRecords[this.iterationIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Codec<T>
    extends Cloneable {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(T var1);

        public T decode();

        public Codec<T> clone();
    }
}

