/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.util.HttpUtils;
import org.broad.tribble.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private long position = 0L;
    private long contentLength = -1L;
    private URL url;

    public SeekableHTTPStream(URL url) {
        String contentLengthString;
        this.url = url;
        if (log.isDebugEnabled()) {
            log.debug("Creating SeekableHTTPStream for: " + url);
        }
        if ((contentLengthString = HttpUtils.getHeaderField(url, "Content-Length")) != null) {
            try {
                this.contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e2) {
                log.error("Error converting content length to number: " + this.contentLength);
            }
        }
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public long skip(long n2) throws IOException {
        long bytesToSkip = Math.min(n2, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int n2;
        InputStream is;
        HttpURLConnection connection;
        block19: {
            int n3;
            block17: {
                block18: {
                    if (log.isDebugEnabled()) {
                        log.debug("read: " + offset + " " + len);
                    }
                    if (offset < 0) throw new IndexOutOfBoundsException();
                    if (len < 0) throw new IndexOutOfBoundsException();
                    if (offset + len > buffer.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return 0;
                    }
                    connection = null;
                    is = null;
                    String byteRange = "";
                    int n4 = 0;
                    try {
                        try {
                            connection = HttpUtils.openConnection(this.url);
                            long endRange = this.position + (long)len - 1L;
                            if (this.contentLength > 0L) {
                                endRange = Math.min(endRange, this.contentLength);
                            }
                            byteRange = "bytes=" + this.position + "-" + endRange;
                            connection.setRequestProperty("Range", byteRange);
                            is = connection.getInputStream();
                            while (n4 < len) {
                                int count = is.read(buffer, offset + n4, len - n4);
                                if (count < 0) {
                                    if (n4 != 0) break;
                                    n3 = -1;
                                    Object var13_12 = null;
                                    if (is == null) break block17;
                                    break block18;
                                }
                                n4 += count;
                            }
                            this.position += (long)n4;
                            n2 = n4;
                            break block19;
                        }
                        catch (IOException e2) {
                            if (!e2.getMessage().contains("416")) {
                                if (!(e2 instanceof EOFException)) throw e2;
                            }
                            if (n4 < 0) {
                                int n5 = -1;
                                Object var13_14 = null;
                                if (is != null) {
                                    is.close();
                                }
                                if (connection == null) return n5;
                                connection.disconnect();
                                return n5;
                            }
                            this.position += (long)n4;
                            this.contentLength = this.position;
                            int n6 = n4;
                            Object var13_15 = null;
                            if (is != null) {
                                is.close();
                            }
                            if (connection == null) return n6;
                            connection.disconnect();
                            return n6;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        if (is != null) {
                            is.close();
                        }
                        if (connection == null) throw throwable;
                        connection.disconnect();
                        throw throwable;
                    }
                }
                is.close();
            }
            if (connection == null) return n3;
            connection.disconnect();
            return n3;
        }
        Object var13_13 = null;
        if (is != null) {
            is.close();
        }
        if (connection == null) return n2;
        connection.disconnect();
        return n2;
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    private void logHeaderFields(HttpURLConnection connection) {
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
    }
}

