/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    private static ProxySettings proxySettings = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderField(URL url, String name) {
        String string;
        HttpURLConnection conn = null;
        try {
            conn = HttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            string = conn.getHeaderField(name);
            Object var6_5 = null;
        }
        catch (Exception e2) {
            String string2;
            try {
                e2.printStackTrace();
                string2 = null;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_7 = null;
                    if (conn == null || !(conn instanceof HttpURLConnection)) break block6;
                    conn.disconnect();
                }
                throw throwable;
            }
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
            return string2;
        }
        if (conn != null && conn instanceof HttpURLConnection) {
            conn.disconnect();
        }
        return string;
    }

    public static long getContentLength(URL url) {
        String contentLengthString = HttpUtils.getHeaderField(url, "Content-length");
        if (contentLengthString == null) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error parsing content length string: " + contentLengthString);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL url) {
        boolean bl;
        HttpURLConnection conn;
        block8: {
            conn = null;
            conn = HttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            if (conn.getHeaderField("ETag") == null) break block8;
            boolean bl2 = true;
            Object var5_5 = null;
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
            return bl2;
        }
        try {
            bl = false;
            Object var5_6 = null;
        }
        catch (Exception e2) {
            boolean bl3;
            try {
                e2.printStackTrace();
                bl3 = false;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var5_8 = null;
                    if (conn == null || !(conn instanceof HttpURLConnection)) break block9;
                    conn.disconnect();
                }
                throw throwable;
            }
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
            return bl3;
        }
        if (conn != null && conn instanceof HttpURLConnection) {
            conn.disconnect();
        }
        return bl;
    }

    public static HttpURLConnection openConnection(URL url) throws IOException {
        if (proxySettings != null && HttpUtils.proxySettings.useProxy && HttpUtils.proxySettings.proxyHost != null && HttpUtils.proxySettings.proxyPort > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(HttpUtils.proxySettings.proxyHost, HttpUtils.proxySettings.proxyPort));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
            if (HttpUtils.proxySettings.auth && HttpUtils.proxySettings.user != null && HttpUtils.proxySettings.pw != null) {
                String encodedUserPwd = HttpUtils.base64Encode(HttpUtils.proxySettings.user + ":" + HttpUtils.proxySettings.pw);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
            return conn;
        }
        return (HttpURLConnection)url.openConnection();
    }

    public static String base64Encode(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] bytes = str.getBytes();
        return encoder.encode(bytes);
    }

    public static String base64Decode(String str) {
        try {
            return new String(new BASE64Decoder().decodeBuffer(str));
        }
        catch (IOException e2) {
            log.error("Error decoding string: " + str, e2);
            return str;
        }
    }

    public static void setProxySettings(ProxySettings ps) {
        proxySettings = ps;
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

