/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.readers.QueryReader;
import org.broad.tribble.util.LineReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabixReader
implements QueryReader,
LineReader {
    private String filename;
    private BlockCompressedInputStream blockCompressedInputStream;
    private int format;
    private int seqCol;
    private int begCol;
    private int endCol;
    private int metaChar;
    private int nSkip;
    private String[] sequences;
    private HashMap<String, Integer> chr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_MIN_CHUNK_GAP = 32768;
    private static int TAD_LIDX_SHIFT = 14;
    private TIndex[] mIndex;

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TabixReader(String fn) throws IOException {
        this.filename = fn;
        this.blockCompressedInputStream = fn.startsWith("http:") || fn.startsWith("https:") ? new BlockCompressedInputStream(new URL(fn)) : new BlockCompressedInputStream(new File(fn));
        this.readIndex();
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.chr2tid.keySet();
    }

    private static int reg2bins(int beg, int _end, int[] bins) {
        int i2 = 0;
        int end = _end;
        --end;
        bins[i2++] = 0;
        int k2 = 1 + (beg >> 26);
        while (k2 <= 1 + (end >> 26)) {
            bins[i2++] = k2++;
        }
        k2 = 9 + (beg >> 23);
        while (k2 <= 9 + (end >> 23)) {
            bins[i2++] = k2++;
        }
        k2 = 73 + (beg >> 20);
        while (k2 <= 73 + (end >> 20)) {
            bins[i2++] = k2++;
        }
        k2 = 585 + (beg >> 17);
        while (k2 <= 585 + (end >> 17)) {
            bins[i2++] = k2++;
        }
        k2 = 4681 + (beg >> 14);
        while (k2 <= 4681 + (end >> 14) && i2 < bins.length) {
            bins[i2++] = k2++;
        }
        return i2;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readNextLine(InputStream is) throws IOException {
        int c2;
        StringBuffer buf = new StringBuffer();
        while ((c2 = is.read()) >= 0 && c2 != 10) {
            buf.append((char)c2);
        }
        if (c2 < 0) {
            return null;
        }
        return buf.toString();
    }

    public void readIndex(BlockCompressedInputStream is) throws IOException {
        int i2;
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        this.sequences = new String[TabixReader.readInt(is)];
        this.chr2tid = new HashMap();
        this.format = TabixReader.readInt(is);
        this.seqCol = TabixReader.readInt(is);
        this.begCol = TabixReader.readInt(is);
        this.endCol = TabixReader.readInt(is);
        this.metaChar = TabixReader.readInt(is);
        this.nSkip = TabixReader.readInt(is);
        int l2 = TabixReader.readInt(is);
        buf = new byte[l2];
        is.read(buf);
        int k2 = 0;
        int j2 = 0;
        for (i2 = 0; i2 < buf.length; ++i2) {
            if (buf[i2] != 0) continue;
            byte[] b2 = new byte[i2 - j2];
            System.arraycopy(buf, j2, b2, 0, b2.length);
            String s = new String(b2);
            this.chr2tid.put(s, k2);
            this.sequences[k2++] = s;
            j2 = i2 + 1;
        }
        this.mIndex = new TIndex[this.sequences.length];
        for (i2 = 0; i2 < this.sequences.length; ++i2) {
            int n_bin = TabixReader.readInt(is);
            this.mIndex[i2] = new TIndex();
            this.mIndex[i2].b = new HashMap();
            for (j2 = 0; j2 < n_bin; ++j2) {
                int bin = TabixReader.readInt(is);
                TPair64[] chunks = new TPair64[TabixReader.readInt(is)];
                for (k2 = 0; k2 < chunks.length; ++k2) {
                    long u = TabixReader.readLong(is);
                    long v = TabixReader.readLong(is);
                    chunks[k2] = new TPair64(u, v);
                }
                this.mIndex[i2].b.put(bin, chunks);
            }
            this.mIndex[i2].l = new long[TabixReader.readInt(is)];
            for (k2 = 0; k2 < this.mIndex[i2].l.length; ++k2) {
                this.mIndex[i2].l[k2] = TabixReader.readLong(is);
            }
        }
        is.close();
    }

    public void readIndex() throws IOException {
        BlockCompressedInputStream bcis = null;
        bcis = this.filename.startsWith("http:") || this.filename.startsWith("https:") || this.filename.startsWith("ftp:") ? new BlockCompressedInputStream(new URL(this.filename + ".tbi")) : new BlockCompressedInputStream(new File(this.filename + ".tbi"));
        this.readIndex(bcis);
    }

    @Override
    public String readLine() throws IOException {
        return TabixReader.readNextLine(this.blockCompressedInputStream);
    }

    private int chr2tid(String chr) {
        if (this.chr2tid.containsKey(chr)) {
            return this.chr2tid.get(chr);
        }
        return -1;
    }

    public int[] parseReg(String reg) {
        int[] ret = new int[3];
        int colon = reg.indexOf(58);
        int hyphen = reg.indexOf(45);
        String chr = colon >= 0 ? reg.substring(0, colon) : reg;
        ret[1] = colon >= 0 ? Integer.parseInt(reg.substring(colon + 1, hyphen)) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(reg.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TIntv getIntv(String s) {
        TIntv intv = new TIntv();
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0) {
            int i2;
            if (++col == this.seqCol) {
                intv.tid = this.chr2tid(s.substring(beg, end));
            } else if (col == this.begCol) {
                intv.end = Integer.parseInt(s.substring(beg, end));
                intv.beg = intv.end++;
                if ((this.format & 0x10000) == 0) {
                    --intv.beg;
                }
            } else if ((this.format & 0xFFFF) == 0) {
                if (col == this.endCol) {
                    intv.end = Integer.parseInt(s.substring(beg, end));
                }
            } else if ((this.format & 0xFFFF) == 1) {
                if (col == 6) {
                    int l2 = 0;
                    String cigar = s.substring(beg, end);
                    int j2 = 0;
                    for (i2 = 0; i2 < cigar.length(); ++i2) {
                        char op;
                        if (cigar.charAt(i2) <= '9' || (op = cigar.charAt(i2)) != 'M' && op != 'D' && op != 'N') continue;
                        l2 += Integer.parseInt(cigar.substring(j2, i2));
                    }
                    intv.end = intv.beg + l2;
                }
            } else if ((this.format & 0xFFFF) == 2 && col == 5) {
                String alt = s.substring(beg, end);
                int max = 1;
                for (i2 = 0; i2 < alt.length(); ++i2) {
                    int j3;
                    if (alt.charAt(i2) != 'D') continue;
                    for (j3 = i2 + 1; j3 < alt.length() && alt.charAt(j3) >= '0' && alt.charAt(j3) <= '9'; ++j3) {
                    }
                    int l3 = Integer.parseInt(alt.substring(i2 + 1, j3));
                    if (max < l3) {
                        max = l3;
                    }
                    i2 = j3 - 1;
                }
                intv.end = intv.beg + max;
            }
            beg = end + 1;
        }
        return intv;
    }

    private TabixLineReader query(int tid, int beg, int end) {
        TPair64[] chunks;
        int i2;
        TIndex idx = this.mIndex[tid];
        int[] bins = new int[MAX_BIN];
        int n_bins = TabixReader.reg2bins(beg, end, bins);
        long min_off = beg >> TAD_LIDX_SHIFT >= idx.l.length ? 0L : idx.l[beg >> TAD_LIDX_SHIFT];
        int n_off = 0;
        for (i2 = 0; i2 < n_bins; ++i2) {
            chunks = idx.b.get(bins[i2]);
            if (chunks == null) continue;
            n_off += chunks.length;
        }
        if (n_off == 0) {
            return null;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        for (i2 = 0; i2 < n_bins; ++i2) {
            chunks = idx.b.get(bins[i2]);
            if (chunks == null) continue;
            for (int j2 = 0; j2 < chunks.length; ++j2) {
                if (!TabixReader.less64(min_off, chunks[j2].v)) continue;
                off[n_off++] = new TPair64(chunks[j2]);
            }
        }
        Arrays.sort(off, 0, n_off);
        int l2 = 0;
        for (i2 = 1; i2 < n_off; ++i2) {
            if (!TabixReader.less64(((TPair64)off[l2]).v, ((TPair64)off[i2]).v)) continue;
            ((TPair64)off[++l2]).u = ((TPair64)off[i2]).u;
            ((TPair64)off[l2]).v = ((TPair64)off[i2]).v;
        }
        n_off = l2 + 1;
        for (i2 = 1; i2 < n_off; ++i2) {
            if (TabixReader.less64(((TPair64)off[i2 - 1]).v, ((TPair64)off[i2]).u)) continue;
            ((TPair64)off[i2 - 1]).v = ((TPair64)off[i2]).u;
        }
        l2 = 0;
        for (i2 = 1; i2 < n_off; ++i2) {
            if (((TPair64)off[l2]).v >> 16 == ((TPair64)off[i2]).u >> 16) {
                ((TPair64)off[l2]).v = ((TPair64)off[i2]).v;
                continue;
            }
            ((TPair64)off[++l2]).u = ((TPair64)off[i2]).u;
            ((TPair64)off[l2]).v = ((TPair64)off[i2]).v;
        }
        n_off = l2 + 1;
        TPair64[] ret = new TPair64[n_off];
        for (i2 = 0; i2 < n_off; ++i2) {
            ret[i2] = new TPair64(((TPair64)off[i2]).u, ((TPair64)off[i2]).v);
        }
        return new TabixLineReader(tid, beg, end, ret);
    }

    public TabixLineReader query(String reg) {
        int[] x = this.parseReg(reg);
        return this.query(x[0], x[1], x[2]);
    }

    @Override
    public LineReader iterate() {
        return this;
    }

    @Override
    public TabixLineReader query(String chr, int start, int end) {
        int tid = this.chr2tid(chr);
        if (tid >= 0) {
            int adjustedStart = Math.max(0, start - 1);
            return this.query(this.chr2tid(chr), adjustedStart, end);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.blockCompressedInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isTabix(String path) {
        boolean bl;
        BlockCompressedInputStream is;
        block13: {
            block11: {
                boolean bl2;
                block12: {
                    if (!path.endsWith("gz")) {
                        return false;
                    }
                    is = null;
                    is = path.startsWith("http:") || path.startsWith("https:") || path.startsWith("ftp:") ? new BlockCompressedInputStream(new URL(path + ".tbi")) : new BlockCompressedInputStream(new File(path + ".tbi"));
                    if (is != null) break block11;
                    bl2 = false;
                    Object var5_5 = null;
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return bl2;
            }
            byte[] bytes = new byte[4];
            is.read(bytes);
            bl = (char)bytes[0] == 'T' && (char)bytes[1] == 'B';
            Object var5_6 = null;
            if (is == null) break block13;
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return bl;
        catch (IOException e3) {
            boolean bl3;
            block14: {
                try {
                    e3.printStackTrace();
                    bl3 = false;
                    Object var5_7 = null;
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    block15: {
                        Object var5_8 = null;
                        if (is == null) break block15;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            return bl3;
        }
    }

    public static void main(String[] args) {
        args = new String[]{"/Users/jrobinso/projects/Version_1.5_rc2/test/data/CEU.SRP000032.2010_03.genotypes.vcf.gz", "1:58003474-58013474"};
        if (args.length < 1) {
            System.out.println("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
            System.exit(1);
        }
        System.out.println(TabixReader.isTabix(args[0]));
        try {
            TabixReader tr = new TabixReader(args[0]);
            if (args.length == 1) {
                String s;
                while ((s = tr.readLine()) != null) {
                    System.out.println(s);
                }
            } else {
                String s;
                TabixLineReader iter = tr.query(args[1]);
                while ((s = iter.readLine()) != null) {
                    System.out.println(s);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class TabixLineReader
    implements LineReader {
        private int i = -1;
        private int n_seeks = 0;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;

        public TabixLineReader(int _tid, int _beg, int _end, TPair64[] _off) {
            this.off = _off;
            this.tid = _tid;
            this.beg = _beg;
            this.end = _end;
        }

        public String readLine() throws IOException {
            block5: {
                String s;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.blockCompressedInputStream.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                            ++this.n_seeks;
                        }
                        ++this.i;
                    }
                    if ((s = TabixReader.readNextLine(TabixReader.this.blockCompressedInputStream)) == null) break block5;
                    char[] str = s.toCharArray();
                    this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                    if (str.length == 0 || str[0] == TabixReader.this.metaChar) continue;
                    TIntv intv = TabixReader.this.getIntv(s);
                    if (intv.tid != this.tid || intv.beg >= this.end) break block5;
                    if (intv.end > this.beg && intv.beg < this.end) break;
                }
                return s;
            }
            this.iseof = true;
            return null;
        }

        public void close() throws IOException {
            TabixReader.this.blockCompressedInputStream.close();
        }
    }

    private class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    private class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        private TIndex() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p2) {
            this.u = p2.u;
            this.v = p2.v;
        }

        @Override
        public int compareTo(TPair64 p2) {
            return this.u == p2.u ? 0 : (this.u < p2.u ^ this.u < 0L ^ p2.u < 0L ? -1 : 1);
        }
    }
}

