/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.UnsortedFileException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.LittleEndianOutputStream;

public class LinearIndexCreator
extends IndexCreator {
    private static Logger log = Logger.getLogger(LinearIndexCreator.class);
    static int DEFAULT_BINWIDTH = 16000;
    private int binWidth = DEFAULT_BINWIDTH;
    private boolean verbose = true;

    public LinearIndexCreator(File featureFile, FeatureCodec codec) {
        super(featureFile, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Index createIndex() throws IOException {
        featureIndex = new LinearIndex(this.binWidth, this.featureFile.getAbsolutePath());
        is = new FileInputStream(this.featureFile);
        reader = new AsciiLineReader(is);
        this.codec.readHeader(reader);
        fileLength = this.featureFile.length();
        progressIncrement = fileLength / 100L;
        currentFilePosition = 0L;
        lastChr = null;
        lastStart = 0;
        lastBinNumber = 0;
        lastBinStart = -1;
        longestFeature = 0;
        progressCounter = 1;
        lineNumber = 0;
        nextLine = "";
        f = null;
        do {
            ++lineNumber;
            filePosition = reader.getPosition();
        } while ((nextLine = reader.readLine()) != null && (f = this.codec.decodeLoc(nextLine)) == null);
        if (f != null) {
            lastChr = f.getChr();
            lastBinStart = f.getStart();
        }
        currentFilePosition = reader.getPosition();
        while ((nextLine = reader.readLine()) != null) {
            ++lineNumber;
            f = this.codec.decodeLoc(nextLine);
            if (f == null) continue;
            chr = f.getChr();
            if (!chr.equals(lastChr)) {
                bytesCount = (int)(currentFilePosition - filePosition);
                featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                lastBinStart = f.getStart();
                filePosition = currentFilePosition;
                lastBinNumber = 0;
                lastStart = 0;
                longestFeature = 0;
                lastChr = chr;
            } else {
                start = f.getStart();
                longestFeature = Math.max(longestFeature, f.getEnd() - start);
                if (start < lastStart) {
                    throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                }
                lastStart = start;
                binNumber = start / this.binWidth;
                if (binNumber > lastBinNumber) {
                    cnt = 0;
                    for (cnt = 0; cnt < lastBinStart / this.binWidth - lastBinNumber; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber += cnt;
                    bytesCount = (int)(currentFilePosition - filePosition);
                    featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                    lastBinStart = f.getStart();
                    filePosition = currentFilePosition;
                    for (cnt = 0; cnt < binNumber - lastBinNumber - 1; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber = binNumber;
                }
            }
            if ((currentFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter);
            ++progressCounter;
        }
        byteCount = (int)(reader.getPosition() - filePosition);
        featureIndex.add(lastChr, filePosition, byteCount, longestFeature);
        is.close();
        if (this.idxFile != null) {
            stream = null;
            try {
                stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.idxFile)));
                featureIndex.write((LittleEndianOutputStream)stream);
                var27_24 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var26_26) {
                var27_25 = null;
                if (stream != null) {
                    stream.close();
                }
                throw var26_26;
            }
lbl-1000:
            // 1 sources

            {
                stream.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        return featureIndex;
    }

    private void updateProgress(int progressCounter) {
        if (this.verbose) {
            System.out.println("Progress: " + progressCounter + "%");
        }
    }

    public int getBinWidth() {
        return this.binWidth;
    }

    public void setBinWidth(int binWidth) {
        this.binWidth = binWidth;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

