/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.index.AbstractIndex;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearIndex
extends AbstractIndex
implements Index {
    private static Logger log = Logger.getLogger(LinearIndex.class);
    private int defaultBinWidth;

    public LinearIndex() {
    }

    public LinearIndex(int binWidth, String featureFile) {
        super(featureFile);
        this.defaultBinWidth = binWidth;
    }

    @Override
    protected int getType() {
        return 1;
    }

    public void add(String chr, long idx, int size, int longestFeature) {
        ChrIndex chrIndex = (ChrIndex)this.chrIndeces.get(chr);
        if (chrIndex == null) {
            chrIndex = new ChrIndex(chr, this.defaultBinWidth);
            this.chrIndeces.put(chr, chrIndex);
        }
        chrIndex.updateLongestFeature(longestFeature);
        chrIndex.addBlock(new Block(idx, size));
    }

    @Override
    public LinkedHashSet<String> getSequenceNames() {
        return this.chrIndeces == null ? new LinkedHashSet<String>() : new LinkedHashSet(this.chrIndeces.keySet());
    }

    @Override
    public Class getIndexClass() {
        return ChrIndex.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChrIndex
    implements org.broad.tribble.index.ChrIndex {
        private String name;
        private int binWidth;
        private int longestFeature;
        private int largestBlockSize;
        private int totalBlockSize;
        private List<Block> blocks;

        public ChrIndex() {
        }

        ChrIndex(LittleEndianInputStream dis) throws IOException {
            this.read(dis);
        }

        ChrIndex(String name, int binWidth) {
            this.name = name;
            this.binWidth = binWidth;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.largestBlockSize = 0;
            this.totalBlockSize = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
            this.totalBlockSize += block.getSize();
            this.largestBlockSize = Math.max(this.largestBlockSize, block.getSize());
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            if (this.blocks == null || this.blocks.isEmpty()) {
                return null;
            }
            int adjustedPosition = Math.max(start - this.longestFeature, 0);
            int startBinNumber = Math.min(adjustedPosition / this.binWidth, this.blocks.size() - 1);
            int endBinNumber = Math.min(end / this.binWidth, this.blocks.size() - 1);
            return this.blocks.subList(startBinNumber, endBinNumber + 1);
        }

        public void updateLongestFeature(int featureLength) {
            this.longestFeature = Math.max(this.longestFeature, featureLength);
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            dos.writeInt(this.binWidth);
            dos.writeInt(this.blocks.size());
            dos.writeInt(this.longestFeature);
            dos.writeInt(this.largestBlockSize);
            dos.writeInt(this.totalBlockSize);
            long pos = 0L;
            int size = 0;
            for (Block block : this.blocks) {
                pos = block.getStartPosition();
                size = block.getSize();
                dos.writeLong(pos);
            }
            dos.writeLong(pos + (long)size);
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.name = dis.readString();
            this.binWidth = dis.readInt();
            int nBins = dis.readInt();
            this.longestFeature = dis.readInt();
            this.largestBlockSize = dis.readInt();
            this.totalBlockSize = dis.readInt();
            this.blocks = new ArrayList<Block>(nBins);
            long pos = dis.readLong();
            for (int binNumber = 0; binNumber < nBins; ++binNumber) {
                long nextPos = dis.readLong();
                int size = (int)(nextPos - pos);
                this.blocks.add(new Block(pos, size));
                pos = nextPos;
            }
        }
    }
}

