/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.ChrIndex;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndex
implements Index {
    private static Logger log = Logger.getLogger(AbstractIndex.class);
    public static int VERSION = 3;
    private int version = VERSION;
    String indexedFile;
    long indexedFileSize;
    long indexedFileTS;
    String indexedFileMD5 = "";
    int flags;
    Map<String, String> properties = new HashMap<String, String>();
    protected LinkedHashMap<String, ChrIndex> chrIndeces = new LinkedHashMap();
    private static final int SEQUENCE_DICTIONARY_FLAG = 32768;

    public AbstractIndex() {
    }

    public AbstractIndex(String featureFile) {
        this.indexedFile = featureFile;
        this.indexedFileSize = featureFile.length();
    }

    @Override
    public boolean isCurrentVersion() {
        return this.version == VERSION;
    }

    public void setMD5(String md5) {
        this.indexedFileMD5 = md5;
    }

    public boolean containsChromosome(String chr) {
        return this.chrIndeces.containsKey(chr);
    }

    protected abstract int getType();

    private void writeHeader(LittleEndianOutputStream dos) throws IOException {
        int magicNumber = 1480870228;
        dos.writeInt(magicNumber);
        dos.writeInt(this.getType());
        dos.writeInt(this.version);
        dos.writeString(this.indexedFile);
        dos.writeLong(this.indexedFileSize);
        dos.writeLong(this.indexedFileTS);
        dos.writeString(this.indexedFileMD5);
        dos.writeInt(this.flags);
        dos.writeInt(this.properties.size());
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            dos.writeString(prop.getKey());
            dos.writeString(prop.getValue());
        }
    }

    private void readHeader(LittleEndianInputStream dis) throws IOException {
        this.version = dis.readInt();
        this.indexedFile = dis.readString();
        this.indexedFileSize = dis.readLong();
        this.indexedFileTS = dis.readLong();
        this.indexedFileMD5 = dis.readString();
        this.flags = dis.readInt();
        if (this.version < 3 && (this.flags & 0x8000) == 32768) {
            this.readSequenceDictionary(dis);
        }
        if (this.version >= 3) {
            int nProperties = dis.readInt();
            while (nProperties-- > 0) {
                String key = dis.readString();
                String value = dis.readString();
                this.properties.put(key, value);
            }
        }
    }

    private void readSequenceDictionary(LittleEndianInputStream dis) throws IOException {
        int size = dis.readInt();
        if (size < 0) {
            throw new IllegalStateException("Size of the sequence dictionary entries is negitive");
        }
        for (int x = 0; x < size; ++x) {
            dis.readString();
            dis.readInt();
        }
    }

    @Override
    public LinkedHashSet<String> getSequenceNames() {
        return new LinkedHashSet<String>(this.chrIndeces.keySet());
    }

    @Override
    public List<Block> getBlocks(String chr, int start, int end) {
        ChrIndex chrIdx = this.chrIndeces.get(chr);
        if (chrIdx == null) {
            return null;
        }
        return chrIdx.getBlocks(start, end);
    }

    public abstract Class getIndexClass();

    @Override
    public void write(LittleEndianOutputStream stream) throws IOException {
        this.writeHeader(stream);
        stream.writeInt(this.chrIndeces.size());
        for (ChrIndex chrIdx : this.chrIndeces.values()) {
            chrIdx.write(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void read(LittleEndianInputStream dis) throws IOException {
        try {
            try {
                this.readHeader(dis);
                int nChromosomes = dis.readInt();
                this.chrIndeces = new LinkedHashMap(nChromosomes * 2);
                while (nChromosomes-- > 0) {
                    ChrIndex chrIdx = (ChrIndex)this.getIndexClass().newInstance();
                    chrIdx.read(dis);
                    this.chrIndeces.put(chrIdx.getName(), chrIdx);
                }
                Object var5_6 = null;
            }
            catch (InstantiationException e2) {
                e2.printStackTrace();
                Object var5_7 = null;
                dis.close();
                return;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
                Object var5_8 = null;
                dis.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            dis.close();
            throw throwable;
        }
        dis.close();
    }
}

