/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UCSCUtils {
    static Set<String> types = new HashSet<String>(Arrays.asList("SINE", "LINE", "LTR", "DNA", "Simple_repeat", "Low_complexity", "Satellite", "RNA", "Other", "Unknown", "Uncategorized"));

    public static void main(String[] args) throws IOException {
        String ifile = "/Users/jrobinso/IGV/mm9/mm9_repmsk.txt";
        String output = "/Users/jrobinso/IGV/mm9//repeat_masker";
        String prefix = "mm9_repmask_";
        UCSCUtils.splitRepeatMasker(ifile, output, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRepeatMasker(String iFile, String outputDirectory, String prefix) throws IOException {
        HashMap<String, PrintWriter> pws;
        block7: {
            BufferedReader br = null;
            pws = new HashMap<String, PrintWriter>();
            try {
                String nextLine;
                br = new BufferedReader(new FileReader(iFile));
                File dir = new File(outputDirectory);
                for (String type : types) {
                    File f2 = new File(dir, prefix + type + ".bed");
                    pws.put(type, new PrintWriter(new BufferedWriter(new FileWriter(f2))));
                }
                while ((nextLine = br.readLine()) != null) {
                    if (nextLine.startsWith("#")) continue;
                    String[] tokens = nextLine.split("\t");
                    String type = UCSCUtils.getType(tokens[5]);
                    ((PrintWriter)pws.get(type)).println(tokens[0] + "\t" + tokens[1] + "\t" + tokens[2] + "\t" + tokens[4] + "\t" + tokens[3]);
                }
                Object var10_9 = null;
                if (br == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (br != null) {
                    br.close();
                }
                for (PrintWriter pw : pws.values()) {
                    pw.close();
                }
                throw throwable;
            }
            br.close();
        }
        for (PrintWriter pw : pws.values()) {
            pw.close();
        }
    }

    public static String getType(String s) {
        if ((s = s.replace("?", "")).contains("RNA")) {
            return "RNA";
        }
        if (s.equals("RC")) {
            return "Other";
        }
        if (s.equals("repClass")) {
            return "Other";
        }
        if (types.contains(s)) {
            return s;
        }
        return "Uncategorized";
    }
}

