/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.GridLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.SeekableHTTPStream;
import org.broad.igv.util.Utilities;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGVHttpUtils {
    private static Logger log = Logger.getLogger(IGVHttpUtils.class);
    private static ProxySettings proxySettings = null;
    static boolean byteRangeTested = false;
    static boolean useByteRange = true;

    private static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new URL(testURL));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5, true);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            SeekableHTTPStream.log.error("Error while testing byte range ", e2);
            return false;
        }
    }

    public static synchronized boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().isUseByteRange();
        if (useByteRange && !byteRangeTested) {
            try {
                useByteRange = IGVHttpUtils.testByteRange();
            }
            catch (Exception e2) {
                log.error("Error testing byte range");
            }
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public static InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toUpperCase().equals("FTP")) {
            return IGVHttpUtils.openFtpStream(url);
        }
        return IGVHttpUtils.openHttpStream(url, (Map<String, String>)null);
    }

    public static InputStream openHttpStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = IGVHttpUtils.openConnectionPrivate(url, requestProperties);
        return IGVHttpUtils.openHttpStream(url, conn);
    }

    public static InputStream openHttpStream(URL url, HttpURLConnection conn) throws IOException {
        while (true) {
            InputStream is = null;
            try {
                is = conn.getInputStream();
                return is;
            }
            catch (SocketTimeoutException e2) {
                throw e2;
            }
            catch (IOException e3) {
                if (conn.getResponseCode() == 401) {
                    if (is != null) {
                        is.close();
                    }
                    conn.disconnect();
                    if (!IGVHttpUtils.getUserPass(url.toExternalForm())) {
                        throw e3;
                    }
                    HashMap<String, String> requestProperties = new HashMap<String, String>();
                    for (Map.Entry<String, List<String>> entry : conn.getRequestProperties().entrySet()) {
                        if (entry.getValue().size() <= 0) continue;
                        requestProperties.put(entry.getKey(), entry.getValue().get(0));
                    }
                    conn.getRequestProperties();
                    conn = IGVHttpUtils.openConnectionPrivate(url, null);
                    continue;
                }
                throw e3;
            }
            break;
        }
    }

    private static InputStream openFtpStream(URL url) throws IOException {
        String host = url.getHost();
        FTPClient ftp = new FTPClient();
        ftp.connect(host);
        System.out.println(ftp.getReplyString());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            ftp.disconnect();
            System.err.println("FTP server refused connection.");
            throw new RuntimeException("FTP server refused connection.");
        }
        boolean success = ftp.login("anonymous", "igv-team@broadinstitute.org");
        if (!success) {
            System.err.println("FTP login failed " + ftp.getReplyString());
            throw new RuntimeException("FTP login failed " + ftp.getReplyString());
        }
        ftp.enterLocalPassiveMode();
        String file = url.getPath();
        System.out.println("Open file: " + file);
        return ftp.retrieveFileStream(file);
    }

    private static HttpURLConnection openConnectionPrivate(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = IGVHttpUtils.openConnection(url);
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Connection", "close");
        if (requestProperties != null) {
            for (Map.Entry<String, String> prop : requestProperties.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue());
            }
        }
        return conn;
    }

    public static HttpURLConnection openConnection(URL url) throws IOException {
        if (IGVHttpUtils.useProxy()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(IGVHttpUtils.proxySettings.proxyHost, IGVHttpUtils.proxySettings.proxyPort));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
            if (IGVHttpUtils.proxySettings.auth && IGVHttpUtils.proxySettings.user != null && IGVHttpUtils.proxySettings.pw != null) {
                String encodedUserPwd = IGVHttpUtils.base64Encode(IGVHttpUtils.proxySettings.user + ":" + IGVHttpUtils.proxySettings.pw);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
            return conn;
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn;
    }

    private static boolean useProxy() {
        return proxySettings != null && IGVHttpUtils.proxySettings.useProxy && IGVHttpUtils.proxySettings.proxyHost != null && IGVHttpUtils.proxySettings.proxyPort > 0;
    }

    public static boolean getUserPass(String locationString) {
        JPanel passPanel = new JPanel();
        passPanel.setLayout(new GridLayout(6, 1));
        JLabel message = new JLabel("Please enter your Username and Password");
        JLabel location = new JLabel(locationString);
        JLabel username = new JLabel("User:");
        JLabel password = new JLabel("Pass:");
        JTextField userField = new JTextField();
        JPasswordField passwordField = new JPasswordField();
        passPanel.add(message);
        passPanel.add(location);
        passPanel.add(username);
        passPanel.add(userField);
        passPanel.add(password);
        passPanel.add(passwordField);
        int a2 = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), passPanel, "Authentication Required", 2, 3);
        if (a2 == 2) {
            return false;
        }
        final String userString = userField.getText();
        final char[] userPass = passwordField.getPassword();
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userString, userPass);
            }
        });
        return true;
    }

    public static void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getBooleanPreference("PROXY.USE", false);
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        auth = prefMgr.getBooleanPreference("PROXY.AUTHENTICATE", false);
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        ProxySettings proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort);
        IGVHttpUtils.setProxySettings(proxySettings);
    }

    public static String base64Encode(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] bytes = str.getBytes();
        return encoder.encode(bytes);
    }

    public static String base64Decode(String str) {
        try {
            return new String(new BASE64Decoder().decodeBuffer(str));
        }
        catch (IOException e2) {
            log.error("Error decoding string: " + str, e2);
            return str;
        }
    }

    public static void setProxySettings(ProxySettings ps) {
        proxySettings = ps;
    }

    public static String getETag(URL url) {
        return IGVHttpUtils.getHeaderField(url, "ETag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderField(URL url, String name) {
        String string;
        HttpURLConnection conn = null;
        try {
            conn = IGVHttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("HEAD");
            string = conn.getHeaderField(name);
            Object var6_5 = null;
        }
        catch (Exception e2) {
            String string2;
            try {
                e2.printStackTrace();
                string2 = null;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_7 = null;
                    if (conn == null || !(conn instanceof HttpURLConnection)) break block6;
                    conn.disconnect();
                }
                throw throwable;
            }
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
            return string2;
        }
        if (conn != null && conn instanceof HttpURLConnection) {
            conn.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL url) {
        boolean bl;
        HttpURLConnection conn = null;
        try {
            conn = IGVHttpUtils.openConnection(url);
            conn.setRequestMethod("HEAD");
            conn.setReadTimeout(5000);
            bl = conn.getHeaderField("ETag") != null;
            Object var5_4 = null;
        }
        catch (Exception e2) {
            boolean bl2;
            try {
                bl2 = false;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_6 = null;
                    if (conn == null || !(conn instanceof HttpURLConnection)) break block6;
                    conn.disconnect();
                }
                throw throwable;
            }
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
            return bl2;
        }
        if (conn != null && conn instanceof HttpURLConnection) {
            conn.disconnect();
        }
        return bl;
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

