/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;

public class ProgressBar
extends JPanel
implements PropertyChangeListener {
    private boolean isReady = false;
    private JProgressBar progressBar;
    private boolean closeOnCompletion = false;
    private Window progressParentWindow;
    private ProgressMonitor monitor;

    public ProgressBar(int minimumProgress, int maximumProgress) {
        this(null, minimumProgress, maximumProgress, false, null);
    }

    public ProgressBar(Window progressParentWindow, int minimumProgress, int maximumProgress, boolean closeOnCompletion, ProgressMonitor monitor) {
        this.progressParentWindow = progressParentWindow;
        this.closeOnCompletion = closeOnCompletion;
        this.monitor = monitor;
        this.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(minimumProgress, maximumProgress);
        this.add(this.progressBar);
        this.setReady(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isReady()) {
            if ("PROGRESS_PROPERTY".equalsIgnoreCase(evt.getPropertyName())) {
                int value = (Integer)evt.getNewValue();
                int progress = value > this.progressBar.getMaximum() ? 100 : value;
                this.progressBar.setValue(progress);
                if (progress > 99 && this.closeOnCompletion) {
                    this.setReady(false);
                    this.progressParentWindow.setVisible(false);
                }
            }
        } else {
            Object source = evt.getSource();
            if (source instanceof ProgressMonitor) {
                ((ProgressMonitor)source).setReady(false);
            }
        }
    }

    public static ProgressBar showProgressDialog(Frame parent, ProgressMonitor monitor, boolean closeOnCompletion) {
        return ProgressBar.showProgressDialog(parent, "", monitor, closeOnCompletion);
    }

    public static ProgressBar showProgressDialog(Frame dialogsParent, String title, ProgressMonitor monitor, boolean closeOnCompletion) {
        ProgressDialog.isAlreadyShowing = true;
        ProgressDialog progressDialog = null;
        if (dialogsParent == null) {
            progressDialog = new ProgressDialog();
            progressDialog.setSize(500, 25);
            UIUtilities.centerWindow(progressDialog);
        }
        progressDialog = new ProgressDialog(dialogsParent);
        progressDialog.setSize(500, 25);
        if (dialogsParent.isVisible()) {
            progressDialog.setLocationRelativeTo(dialogsParent);
        } else {
            UIUtilities.centerWindow(progressDialog);
        }
        final ProgressBar bar = new ProgressBar(progressDialog, 0, 100, closeOnCompletion, monitor);
        bar.setSize(500, 25);
        bar.setPreferredSize(bar.getSize());
        progressDialog.setDefaultCloseOperation(2);
        progressDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                bar.setReady(false);
                ProgressDialog.isAlreadyShowing = false;
            }
        });
        progressDialog.setModal(false);
        progressDialog.setTitle(title);
        progressDialog.getContentPane().add(bar);
        progressDialog.pack();
        monitor.addPropertyChangeListener(bar);
        progressDialog.setVisible(true);
        return bar;
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
        if (value > 99 && this.closeOnCompletion) {
            this.setReady(false);
            this.progressParentWindow.setVisible(false);
        }
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void reset() {
        this.progressBar.setValue(0);
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
        if (this.monitor != null) {
            this.monitor.setReady(ready);
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void close() {
        this.setReady(false);
        if (this.progressParentWindow != null) {
            this.setValue(100);
            this.progressParentWindow.setVisible(false);
            ProgressDialog.isAlreadyShowing = false;
        }
    }

    public static class ProgressDialog
    extends JDialog {
        public static boolean isAlreadyShowing = false;

        public ProgressDialog() {
        }

        public ProgressDialog(Frame frame) {
            super(frame);
        }
    }
}

