/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.broad.igv.ui.util.FilterComponent;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterPane
extends JPanel {
    private Filter filter;
    protected List<String> itemList;
    protected String itemListLabel;
    private Component[] filterComponentBackup;

    public FilterPane(List<String> items, String itemListLabel, Filter filter) {
        this.initComponents();
        this.itemList = new ArrayList<String>(items);
        this.itemListLabel = itemListLabel;
        if (filter != null) {
            this.filter = filter;
            FilterComponent filterComponent = null;
            Iterator iterator = filter.getFilterElements();
            while (iterator.hasNext()) {
                FilterElement element = (FilterElement)iterator.next();
                filterComponent = this.createFilterComponent(this, itemListLabel, this.itemList, element);
                filterComponent.displayMoreButton(false);
                this.add(filterComponent);
            }
            if (filterComponent != null) {
                filterComponent.displayMoreButton(true);
            }
        } else {
            this.filter = this.createNewFilter();
        }
        this.backup();
        if (this.filter.isEmpty()) {
            this.more();
        }
    }

    protected abstract Filter createNewFilter();

    protected abstract FilterComponent createFilterComponent(FilterPane var1, String var2, List<String> var3, FilterElement var4);

    public Filter getFilter() {
        return this.filter;
    }

    public void setItems(List<String> items) {
        if (items == null || items.size() < 1) {
            this.itemList = new ArrayList<String>();
            return;
        }
        this.itemList = new ArrayList<String>(items);
    }

    public boolean more() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (!this.isFilterValid()) {
            JOptionPane.showMessageDialog(window, "Some of the filter values are missing.\nPlease enter all value before pressing ok.");
            return false;
        }
        this.addDefaultFilterComponent();
        if (window != null) {
            window.pack();
        }
        return true;
    }

    protected abstract void addDefaultFilterComponent();

    @Override
    public Component add(Component component, int arg1) {
        if (component instanceof JButton) {
            if (((JButton)component).getText().equals("More...")) {
                return super.add(component, arg1);
            }
            return component;
        }
        if (!(component instanceof FilterComponent)) {
            throw new RuntimeException("Invalid FilterComponent!");
        }
        return super.add(component, arg1);
    }

    @Override
    public void add(Component component, Object arg1, int arg2) {
        if (component instanceof JButton) {
            if (((JButton)component).getText().equals("More...")) {
                super.add(component, arg1, arg2);
            }
        } else if (!(component instanceof FilterComponent)) {
            throw new RuntimeException("Invalid FilterComponent!");
        }
        super.add(component, arg1, arg2);
    }

    @Override
    public void add(Component component, Object arg1) {
        if (component instanceof JButton) {
            if (((JButton)component).getText().equals("More...")) {
                super.add(component, arg1);
            }
        } else if (!(component instanceof FilterComponent)) {
            throw new RuntimeException("Invalid FilterComponent!");
        }
        super.add(component, arg1);
    }

    @Override
    public Component add(Component component) {
        if (component instanceof JButton) {
            if (((JButton)component).getText().equals("More...")) {
                return super.add(component);
            }
            return component;
        }
        if (!(component instanceof FilterComponent)) {
            throw new RuntimeException("Invalid FilterComponent!");
        }
        return super.add(component);
    }

    @Override
    public Component add(String arg0, Component component) {
        if (component instanceof JButton) {
            if (((JButton)component).getText().equals("More...")) {
                return super.add(arg0, component);
            }
            return component;
        }
        if (!(component instanceof FilterComponent)) {
            throw new RuntimeException("Invalid FilterComponent!");
        }
        return super.add(arg0, component);
    }

    public void save() {
        Component[] children;
        for (Component child : children = this.getComponents()) {
            if (!(child instanceof FilterComponent)) continue;
            ((FilterComponent)child).save();
        }
    }

    public boolean isFilterValid() {
        Component[] children;
        boolean isValid = true;
        for (Component child : children = this.getComponents()) {
            if (!(child instanceof FilterComponent)) continue;
            FilterComponent filterComponent = (FilterComponent)child;
            String item = filterComponent.getItem();
            if (item == null || item.trim().equals("")) {
                return false;
            }
            String operator = filterComponent.getComparisonOperator();
            if (operator == null || operator.trim().equals("")) {
                return false;
            }
            String expectedValue = filterComponent.getExpectedValue();
        }
        return isValid;
    }

    public void backup() {
        this.filterComponentBackup = this.getComponents();
    }

    protected void adjustMoreAndBooleanButtonVisibility() {
        if (this.filterComponentBackup != null) {
            Component[] components;
            for (Component component : components = this.getComponents()) {
                ((FilterComponent)component).displayMoreButton(false);
            }
            int last = components.length - 1;
            ((FilterComponent)components[last]).displayMoreButton(true);
        }
    }

    public void restore() {
        if (this.filterComponentBackup != null) {
            Component[] components;
            this.removeAll();
            this.filter.removeAll();
            for (Component component : components = this.filterComponentBackup) {
                ((FilterComponent)component).displayMoreButton(false);
                this.add(component);
                this.filter.add(((FilterComponent)component).getFilterElement());
            }
            if (components.length > 0) {
                int last = components.length - 1;
                ((FilterComponent)components[last]).displayMoreButton(true);
            }
            this.filterComponentBackup = null;
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(500, 100));
        this.setPreferredSize(new Dimension(700, 100));
        this.setLayout(new FlowLayout(0, 5, 0));
    }
}

