/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.broad.igv.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckListDialog
extends JDialog {
    private boolean canceled = true;
    private Set<String> selections;
    private Set<String> nonSelections;
    private List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JPanel checkboxPane;
    private JCheckBox allCB;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public CheckListDialog(Frame owner, List<String> choices, Collection<String> selections, boolean selectionState) {
        super(owner);
        this.initComponents();
        this.initCheckboxes(choices, selections, selectionState);
    }

    public CheckListDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void initCheckboxes(List<String> tmp, Collection<String> selections, boolean selectionState) {
        ArrayList<String> choices = new ArrayList<String>(tmp);
        Collections.sort(choices, Utilities.getNumericStringComparator());
        boolean allSelected = true;
        for (String s : choices) {
            JCheckBox cb = new JCheckBox(s);
            if (selections == null) {
                cb.setSelected(!selectionState);
                allSelected = !selectionState;
            } else if (selectionState && selections.contains(s) || !selectionState && !selections.contains(s)) {
                cb.setSelected(true);
            } else {
                allSelected = false;
                cb.setSelected(false);
            }
            this.checkboxPane.add(cb);
            this.checkBoxes.add(cb);
        }
        this.allCB.setSelected(allSelected);
        this.getContentPane().validate();
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.selections = new HashSet<String>();
        this.nonSelections = new HashSet<String>();
        for (JCheckBox cb : this.checkBoxes) {
            if (cb.isSelected()) {
                this.selections.add(cb.getText());
                continue;
            }
            this.nonSelections.add(cb.getText());
        }
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void allCBActionPerformed(ActionEvent e2) {
        for (JCheckBox cb : this.checkBoxes) {
            cb.setSelected(this.allCB.isSelected());
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.checkboxPane = new JPanel();
        this.allCB = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.checkboxPane.setLayout(new BoxLayout(this.checkboxPane, 1));
        this.allCB.setText("All");
        this.allCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CheckListDialog.this.allCBActionPerformed(e2);
            }
        });
        this.checkboxPane.add(this.allCB);
        this.scrollPane1.setViewportView(this.checkboxPane);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CheckListDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CheckListDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add(this.dialogPane);
        this.dialogPane.setBounds(0, 0, 468, 551);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < contentPane.getComponentCount(); ++i2) {
            Rectangle bounds = contentPane.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = contentPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        contentPane.setMinimumSize(preferredSize);
        contentPane.setPreferredSize(preferredSize);
        this.setSize(470, 575);
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Set<String> getSelections() {
        return this.selections;
    }

    public Set<String> getNonSelections() {
        return this.nonSelections;
    }
}

