/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionOfInterestPanel
extends JPanel {
    PopupMenu popup;
    private RegionOfInterest selectedRegion = null;

    public RegionOfInterestPanel() {
        this.setToolTipText("Regions of Interest");
        ROIMouseAdapater ma = new ROIMouseAdapater();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.drawRegionsOfInterest((Graphics2D)g2, this.getHeight());
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, this.getWidth(), this.getHeight());
    }

    Collection<RegionOfInterest> getRegions() {
        return IGVMainFrame.getInstance().getSession().getRegionsOfInterest(ViewContext.getInstance().getChrName());
    }

    public void drawRegionsOfInterest(Graphics2D g2, int height) {
        ViewContext viewContext = ViewContext.getInstance();
        Collection<RegionOfInterest> regions = this.getRegions();
        if (regions == null || regions.isEmpty()) {
            return;
        }
        for (RegionOfInterest regionOfInterest : regions) {
            Integer regionStart = regionOfInterest.getStart();
            if (regionStart == null) continue;
            Integer regionEnd = regionOfInterest.getEnd();
            if (regionEnd == null) {
                regionEnd = regionStart;
            }
            int start = viewContext.getPixelPosition(regionStart.intValue());
            int end = viewContext.getPixelPosition(regionEnd.intValue());
            int regionWidth = Math.max(1, end - start);
            g2.setColor(regionOfInterest.getBackgroundColor());
            g2.setBackground(regionOfInterest.getBackgroundColor());
            g2.fillRect(start, 0, regionWidth, height);
        }
    }

    RegionOfInterest getRegionOfInterest(int px) {
        double pos = ViewContext.getInstance().getChromosomePosition(px);
        Collection<RegionOfInterest> roiList = this.getRegions();
        if (roiList != null) {
            for (RegionOfInterest roi : roiList) {
                if (!(pos > (double)roi.getStart().intValue()) || !(pos < (double)roi.getEnd().intValue())) continue;
                return roi;
            }
        }
        return null;
    }

    protected JPopupMenu getPopupMenu(final RegionOfInterest roi) {
        JMenuItem item;
        Set<TrackType> loadedTypes = IGVMainFrame.getInstance().getTrackManager().getLoadedTypes();
        JPopupMenu popupMenu = new JPopupMenu();
        if (loadedTypes.contains((Object)TrackType.COPY_NUMBER) || loadedTypes.contains((Object)TrackType.ALLELE_SPECIFIC_COPY_NUMBER) || loadedTypes.contains((Object)TrackType.CNV)) {
            item = new JMenuItem("Sort by amplification");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    IGVMainFrame.getInstance().getTrackManager().sortByRegionScore(roi, RegionScoreType.AMPLIFICATION);
                    IGVMainFrame.getInstance().getContentPane().repaint();
                }
            });
            popupMenu.add(item);
            item = new JMenuItem("Sort by deletion");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    IGVMainFrame.getInstance().getTrackManager().sortByRegionScore(roi, RegionScoreType.DELETION);
                    IGVMainFrame.getInstance().getContentPane().repaint();
                }
            });
            popupMenu.add(item);
            item = new JMenuItem("Sort by breakpoint amplitudes");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    IGVMainFrame.getInstance().getTrackManager().sortByRegionScore(roi, RegionScoreType.FLUX);
                    IGVMainFrame.getInstance().getContentPane().repaint();
                }
            });
            popupMenu.add(item);
        }
        if (loadedTypes.contains((Object)TrackType.GENE_EXPRESSION)) {
            item = new JMenuItem("Sort by expression");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    IGVMainFrame.getInstance().getTrackManager().sortByRegionScore(roi, RegionScoreType.EXPRESSION);
                    IGVMainFrame.getInstance().getContentPane().repaint();
                }
            });
            popupMenu.add(item);
        }
        item = new JMenuItem("Sort by value");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.getInstance().getTrackManager().sortByRegionScore(roi, RegionScoreType.SCORE);
                IGVMainFrame.getInstance().getContentPane().repaint();
            }
        });
        popupMenu.add(item);
        popupMenu.addSeparator();
        item = new JMenuItem("Zoom");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ViewContext.getInstance().jumpTo(roi.getChr(), roi.getStart(), roi.getEnd());
                String locusString = roi.getLocusString();
                ViewContext.getInstance().history.push(locusString);
            }
        });
        popupMenu.add(item);
        item = new JMenuItem("Edit description...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                String desc = JOptionPane.showInputDialog(RegionOfInterestPanel.this, "Add or edit region description:", roi.getDescription());
                roi.setDescription(desc);
            }
        });
        popupMenu.add(item);
        item = new JMenuItem("Copy sequence");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LongRunningTask.submit(new NamedRunnable(){

                    public String getName() {
                        return "Copy sequence";
                    }

                    public void run() {
                        String genomeId = ViewContext.getInstance().getGenomeId();
                        byte[] seqBytes = SequenceManager.readSequence(genomeId, roi.getChr(), roi.getStart(), roi.getEnd());
                        if (seqBytes == null) {
                            MessageUtils.showMessage("Sequence not available");
                        } else {
                            String sequence = new String(seqBytes);
                            StringSelection stringSelection = new StringSelection(sequence);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(stringSelection, null);
                        }
                    }
                });
            }
        });
        if (roi.getEnd() - roi.getStart() > 1000000) {
            item.setEnabled(false);
        }
        popupMenu.add(item);
        popupMenu.add(new JSeparator());
        item = new JMenuItem("Delete");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                RegionOfInterestPanel.this.getRegions().remove(roi);
                IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
            }
        });
        popupMenu.add(item);
        return popupMenu;
    }

    public RegionOfInterest getSelectedRegion() {
        return this.selectedRegion;
    }

    public void setSelectedRegion(RegionOfInterest selectedRegion) {
        this.selectedRegion = selectedRegion;
    }

    class ROIMouseAdapater
    extends MouseInputAdapter {
        ROIMouseAdapater() {
        }

        public void mousePressed(MouseEvent e2) {
            this.showPopup(e2);
        }

        public void mouseReleased(MouseEvent e2) {
            this.showPopup(e2);
        }

        public void mouseMoved(MouseEvent e2) {
            RegionOfInterest roi = RegionOfInterestPanel.this.getRegionOfInterest(e2.getX());
            if (roi != null) {
                RegionOfInterestPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                RegionOfInterestPanel.this.setToolTipText(roi.getTooltip());
                if (RegionOfInterestPanel.this.selectedRegion != roi) {
                    RegionOfInterestPanel.this.selectedRegion = roi;
                    IGVMainFrame.getInstance().repaintDataPanels();
                }
            } else {
                if (RegionOfInterestPanel.this.selectedRegion != null) {
                    RegionOfInterestPanel.this.selectedRegion = null;
                    IGVMainFrame.getInstance().repaintDataPanels();
                }
                RegionOfInterestPanel.this.setToolTipText("");
                RegionOfInterestPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void showPopup(MouseEvent e2) {
            RegionOfInterest roi = RegionOfInterestPanel.this.getRegionOfInterest(e2.getX());
            if (roi != null) {
                RegionOfInterestPanel.this.getPopupMenu(roi).show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }
    }
}

