/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.util.Packable;
import org.broad.igv.ui.util.UIUtilities;

public class AttributeHeaderPanel
extends JPanel
implements Packable {
    private int attributeCount = 0;
    static final int MAXIMUM_FONT_SIZE = 10;
    static final int ATTRIBUTE_COLUMN_WIDTH = 10;
    static final int COLUMN_BORDER_WIDTH = 2;
    private boolean isSortAscending = true;

    public AttributeHeaderPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension size = this.getSize();
        Graphics2D graphics2 = (Graphics2D)graphics.create();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2.setColor(Color.BLACK);
        final List<String> keys = AttributeManager.getInstance().getAttributeKeys();
        Set<String> hiddenKeys = AttributeManager.getInstance().getHiddenAttributes();
        keys.removeAll(hiddenKeys);
        int columnWidth = this.getAttributeColumnWidth();
        int fontSize = (int)(0.9 * (double)columnWidth);
        if (fontSize > 10) {
            fontSize = 10;
        }
        Font font = FontManager.getScalableFont(fontSize);
        final int count = keys.size();
        if (count > 0) {
            if (this.attributeCount != count) {
                this.removeAll();
                if (keys != null) {
                    this.setLayout(new GridLayout(1, count));
                }
            }
            AffineTransform transform = AffineTransform.getTranslateInstance(0.0, size.height - 2);
            graphics2.transform(transform);
            transform = AffineTransform.getRotateInstance(-1.5707963267948966);
            graphics2.transform(transform);
            graphics2.setFont(font);
            FontMetrics fm = graphics2.getFontMetrics();
            int fontAscent = fm.getHeight();
            int i2 = 1;
            int x = 0;
            for (String key : keys) {
                int columnLeftEdge = 12 * i2++;
                x = columnLeftEdge + (12 - fontAscent) / 2;
                graphics2.drawString(key, 0, x);
            }
        }
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                for (String key : keys) {
                    if (AttributeHeaderPanel.this.attributeCount == count) continue;
                    AttributeHeaderPanel.this.addMousableRegion(key);
                }
                if (AttributeHeaderPanel.this.attributeCount != count) {
                    AttributeHeaderPanel.this.attributeCount = count;
                    AttributeHeaderPanel.this.doLayout();
                }
            }
        });
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    public void packHorizontally() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    private int calculatePackWidth() {
        if (!PreferenceManager.getInstance().getShowAttributeView()) {
            return 0;
        }
        HashSet<String> allAttributes = new HashSet<String>(AttributeManager.getInstance().getAttributeKeys());
        Set<String> hiddenAttributes = AttributeManager.getInstance().getHiddenAttributes();
        allAttributes.removeAll(hiddenAttributes);
        int numberOfAttributes = allAttributes.size();
        int packWidth = numberOfAttributes * 12 + 2;
        return packWidth;
    }

    public void packComponent() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.calculatePackWidth(), height);
    }

    private void addMousableRegion(String tooltip) {
        final Region region = new Region();
        region.setName(tooltip);
        region.setToolTipText(tooltip);
        MouseInputAdapter listener = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent e2) {
                String[] selectedAttribute = new String[]{region.getName()};
                boolean[] sortAscending = new boolean[]{AttributeHeaderPanel.this.isSortAscending};
                AttributeHeaderPanel.this.sortTrackByAttribute(selectedAttribute, sortAscending);
                AttributeHeaderPanel.this.isSortAscending = !AttributeHeaderPanel.this.isSortAscending;
            }

            public void mouseEntered(MouseEvent e2) {
                region.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e2) {
            }

            public void mouseReleased(MouseEvent e2) {
            }
        };
        region.addMouseMotionListener(listener);
        region.addMouseListener(listener);
        this.add(region);
    }

    public final void sortTrackByAttribute(String[] selectedSortKeys, boolean[] isSortAscending) {
        if (selectedSortKeys != null) {
            IGVMainFrame.getInstance().getTrackManager().sortAllTracksByAttributes(selectedSortKeys, isSortAscending);
            IGVMainFrame.getInstance().getContentPane().repaint();
        }
    }

    private static class Region
    extends JPanel {
        private Region() {
        }

        public boolean isOpaque() {
            return false;
        }
    }
}

