/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import com.jidesoft.combobox.ColorComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.jdesktop.layout.GroupLayout;

public class HeatmapLegendEditor
extends JDialog {
    private boolean canceled = true;
    private ContinuousColorScale colorScheme;
    private TrackType type;
    private JButton cancelButton;
    private JCheckBox doubleGradientCheckbox;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private ColorComboBox maxColor;
    private ColorComboBox midColor;
    private JLabel midColorLabel;
    private ColorComboBox minColor;
    private JLabel minColorLabel;
    private JTextField negRangeEnd;
    private JLabel negRangeLabel;
    private JPanel negRangePanel;
    private JTextField negRangeStart;
    private JLabel negRangeToLabel;
    private JButton okButton;
    private JTextField posRangeEnd;
    private JLabel posRangeLabel;
    private JPanel posRangePanel;
    private JTextField posRangeStart;
    private JLabel posRangeToLabel;

    public HeatmapLegendEditor(Frame parent, boolean modal, TrackType type, ColorScale colorScheme) {
        super(parent, modal);
        this.colorScheme = (ContinuousColorScale)colorScheme;
        this.type = type;
        this.initComponents();
        this.initValues();
        this.setLocationRelativeTo(parent);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initValues() {
        this.doubleGradientCheckbox.setSelected(this.getColorScheme().isUseDoubleGradient());
        this.negRangeStart.setText(String.valueOf(this.getColorScheme().getNegStart()));
        this.negRangeEnd.setText(String.valueOf(this.getColorScheme().getMinimum()));
        this.posRangeStart.setText(String.valueOf(this.getColorScheme().getPosStart()));
        this.posRangeEnd.setText(String.valueOf(this.getColorScheme().getMaximum()));
        this.minColor.setSelectedColor(this.getColorScheme().getMinColor());
        this.maxColor.setSelectedColor(this.getColorScheme().getMaxColor());
        Color mc = this.getColorScheme().getMidColor();
        this.midColor.setSelectedColor(mc == null ? Color.white : mc);
        this.initDoubleGradientState();
    }

    private void initDoubleGradientState() {
        boolean doubleGradient = this.doubleGradientCheckbox.isSelected();
        this.negRangePanel.setVisible(doubleGradient);
        this.midColorLabel.setVisible(doubleGradient);
        this.midColor.setVisible(doubleGradient);
        this.posRangeLabel.setText(doubleGradient ? "Positive Range " : "Range");
    }

    private boolean updateValues() {
        try {
            double negStart = 0.0;
            double negEnd = 0.0;
            double posStart = Double.parseDouble(this.posRangeStart.getText());
            double posEnd = Double.parseDouble(this.posRangeEnd.getText());
            negStart = Double.parseDouble(this.negRangeStart.getText());
            negEnd = Double.parseDouble(this.negRangeEnd.getText());
            this.colorScheme = new ContinuousColorScale(Math.max(negStart, negEnd), Math.min(negStart, negEnd), Math.min(posStart, posEnd), Math.max(posStart, posEnd), this.minColor.getSelectedColor(), this.midColor.getSelectedColor(), this.maxColor.getSelectedColor());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Limit fields must be numeric.", "Error", 0);
            return false;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.midColorLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.minColorLabel = new JLabel();
        this.minColor = new ColorComboBox();
        this.midColor = new ColorComboBox();
        this.maxColor = new ColorComboBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.negRangePanel = new JPanel();
        this.negRangeLabel = new JLabel();
        this.negRangeStart = new JTextField();
        this.negRangeToLabel = new JLabel();
        this.negRangeEnd = new JTextField();
        this.doubleGradientCheckbox = new JCheckBox();
        this.posRangePanel = new JPanel();
        this.posRangeLabel = new JLabel();
        this.posRangeStart = new JTextField();
        this.posRangeToLabel = new JLabel();
        this.posRangeEnd = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.midColorLabel.setText("Midpoint Color");
        this.jLabel3.setText("Maximum Color");
        this.minColorLabel.setText("Minimum Color");
        this.minColor.setColorValueVisible(false);
        this.midColor.setColorValueVisible(false);
        this.maxColor.setColorValueVisible(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0, 28, Short.MAX_VALUE).add(this.maxColor, -2, 50, -2)).add(jPanel1Layout.createSequentialGroup().add(this.minColorLabel).addPreferredGap(0, 31, Short.MAX_VALUE).add(this.minColor, -2, 50, -2)).add(2, jPanel1Layout.createSequentialGroup().add(this.midColorLabel).addPreferredGap(0, 34, Short.MAX_VALUE).add(this.midColor, -2, 50, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.minColorLabel).addPreferredGap(1).add(this.midColorLabel)).add(this.minColor, -2, 25, -2).add(jPanel1Layout.createSequentialGroup().add(39, 39, 39).add(this.midColor, -2, 25, -2))).add(12, 12, 12).add(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().add(this.jLabel3).add(20, 20, 20)).add(jPanel1Layout.createSequentialGroup().addPreferredGap(1).add(this.maxColor, -2, 25, -2).addContainerGap()))));
        jPanel1Layout.linkSize(new Component[]{this.midColor, this.midColorLabel}, 2);
        jPanel1Layout.linkSize(new Component[]{this.jLabel3, this.maxColor}, 2);
        jPanel1Layout.linkSize(new Component[]{this.minColor, this.minColorLabel}, 2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatmapLegendEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatmapLegendEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.negRangeLabel.setText("Negative Range: ");
        this.negRangeStart.setText("-0.1");
        this.negRangeToLabel.setText("To:");
        this.negRangeEnd.setText("-1.5");
        this.negRangeEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatmapLegendEditor.this.negRangeEndActionPerformed(evt);
            }
        });
        GroupLayout negRangePanelLayout = new GroupLayout(this.negRangePanel);
        this.negRangePanel.setLayout(negRangePanelLayout);
        negRangePanelLayout.setHorizontalGroup(negRangePanelLayout.createParallelGroup(1).add(negRangePanelLayout.createSequentialGroup().add(this.negRangeLabel, -2, 115, -2).addPreferredGap(0).add(this.negRangeStart, -2, 59, -2).addPreferredGap(1).add(this.negRangeToLabel, -2, 30, -2).addPreferredGap(0).add(this.negRangeEnd, -2, 59, -2)));
        negRangePanelLayout.setVerticalGroup(negRangePanelLayout.createParallelGroup(1).add(negRangePanelLayout.createSequentialGroup().add(negRangePanelLayout.createParallelGroup(1).add(this.negRangeLabel, -2, 22, -2).add(negRangePanelLayout.createParallelGroup(3).add(this.negRangeStart, -2, -1, -2).add(this.negRangeToLabel, -2, 22, -2).add(this.negRangeEnd, -2, -1, -2))).addContainerGap(8, Short.MAX_VALUE)));
        this.doubleGradientCheckbox.setText("Use Double Gradient");
        this.doubleGradientCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatmapLegendEditor.this.doubleGradientCheckboxActionPerformed(evt);
            }
        });
        this.posRangeLabel.setText("Positive Range: ");
        this.posRangeStart.setText("-0.1");
        this.posRangeToLabel.setText("To:");
        this.posRangeEnd.setText("-1.5");
        this.posRangeEnd.setMaximumSize(new Dimension(36, 22));
        this.posRangeEnd.setMinimumSize(new Dimension(36, 22));
        GroupLayout posRangePanelLayout = new GroupLayout(this.posRangePanel);
        this.posRangePanel.setLayout(posRangePanelLayout);
        posRangePanelLayout.setHorizontalGroup(posRangePanelLayout.createParallelGroup(1).add(posRangePanelLayout.createSequentialGroup().add(this.posRangeLabel, -2, 115, -2).addPreferredGap(0).add(this.posRangeStart, -2, 59, -2).addPreferredGap(1).add(this.posRangeToLabel, -2, 30, -2).addPreferredGap(0).add(this.posRangeEnd, -2, 59, -2)));
        posRangePanelLayout.setVerticalGroup(posRangePanelLayout.createParallelGroup(1).add(posRangePanelLayout.createSequentialGroup().add(posRangePanelLayout.createParallelGroup(1).add(this.posRangeLabel, -2, 22, -2).add(posRangePanelLayout.createParallelGroup(3).add(this.posRangeStart, -2, -1, -2).add(this.posRangeToLabel, -2, 22, -2).add(this.posRangeEnd, -2, -1, -2))).addContainerGap(8, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(35, 35, 35).add(layout.createParallelGroup(1, false).add(this.doubleGradientCheckbox, -2, 175, -2).add(this.jPanel1, -2, -1, -2).add(this.negRangePanel, -1, -1, Short.MAX_VALUE).add(2, this.posRangePanel, -1, -1, Short.MAX_VALUE)).addContainerGap(88, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().addContainerGap(132, Short.MAX_VALUE).add(this.okButton).addPreferredGap(0).add(this.cancelButton).add(132, 132, 132)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(52, 52, 52).add(this.doubleGradientCheckbox).add(18, 18, 18).add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.negRangePanel, -2, 30, -2).addPreferredGap(1).add(this.posRangePanel, -2, 30, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).add(34, 34, 34)));
        this.pack();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.canceled = false;
        if (this.updateValues()) {
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void negRangeEndActionPerformed(ActionEvent evt) {
    }

    private void doubleGradientCheckboxActionPerformed(ActionEvent evt) {
        this.initDoubleGradientState();
    }

    public ContinuousColorScale getColorScheme() {
        return this.colorScheme;
    }
}

