/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.SortDialog;
import org.broad.igv.ui.util.UIUtilities;

public class SortTracksMenuAction
extends MenuAction {
    IGVMainFrame mainFrame;

    public SortTracksMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Sort tracks by attribute value");
    }

    public void actionPerformed(ActionEvent e2) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                SortTracksMenuAction.this.doSortTrackByAttribute();
            }
        });
    }

    public final void doSortTrackByAttribute() {
        List<String> keys = AttributeManager.getInstance().getAttributeKeys();
        Object[] availableSortKeys = keys.toArray();
        SortDialog dialog = new SortDialog((Frame)this.mainFrame, true, availableSortKeys);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        String[] selectedSortKeys = dialog.getSelectedSortKeys();
        if (selectedSortKeys != null) {
            IGVMainFrame.getInstance().getTrackManager().sortAllTracksByAttributes(selectedSortKeys, dialog.isAscending());
            this.mainFrame.repaint();
        }
    }
}

