/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Collection;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileChooser;
import org.broad.igv.ui.util.MessageUtils;

public class RegionsBaseMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(RegionsBaseMenuAction.class);
    IGVMainFrame mainFrame;

    public RegionsBaseMenuAction(String name, Icon icon, int mnemonic) {
        super(name, icon, mnemonic);
    }

    public final void importExportRegionsOfInterest(Direction direction) {
        File exportRegionDirectory = PreferenceManager.getInstance().getLastExportedRegionDirectory();
        if (exportRegionDirectory == null) {
            exportRegionDirectory = UIConstants.getUserDirectory();
        }
        FileChooser exportedRegionFileChooser = new FileChooser(exportRegionDirectory);
        String title = null;
        title = direction == Direction.EXPORT ? "Export Regions of Interest ..." : "Import Regions of Interest ...";
        exportedRegionFileChooser.setDialogTitle(title);
        File file = this.selectExportedRegionsFile(exportedRegionFileChooser, new File("regions.bed"), direction == Direction.EXPORT);
        if (file == null) {
            return;
        }
        if (direction == Direction.EXPORT) {
            this.writeRegionsOfInterestFile(file);
        } else {
            this.readRegionsOfInterestFile(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info("A blank Region of Interest import file was supplied!");
            return;
        }
        if (!roiFile.exists()) {
            MessageUtils.showMessage("Region of Interest export file not found!");
            return;
        }
        try {
            block11: {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(roiFile));
                    while (true) {
                        String dataRecord;
                        if ((dataRecord = reader.readLine()) == null) {
                            Object var8_9 = null;
                            if (reader == null) break block11;
                            break;
                        }
                        String[] data = dataRecord.split("\t");
                        if (data.length < 3) continue;
                        try {
                            String name = data.length > 3 ? data[3] : null;
                            RegionOfInterest regionOfInterest = new RegionOfInterest(data[0], Integer.parseInt(data[1]), Integer.parseInt(data[2]), name);
                            this.mainFrame.addRegionOfInterest(regionOfInterest);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (reader != null) {
                        reader.close();
                    }
                    this.mainFrame.doRefresh();
                    throw throwable;
                }
                reader.close();
            }
            this.mainFrame.doRefresh();
            return;
        }
        catch (Exception e2) {
            log.error("Failed to write Region of Interest export file!", e2);
            return;
        }
    }

    private File selectExportedRegionsFile(FileChooser exportedRegionFileChooser, File currentFile, boolean isSave) {
        File directory;
        exportedRegionFileChooser.setSelectedFile(currentFile);
        if (isSave) {
            exportedRegionFileChooser.showSaveDialog(this.mainFrame);
        } else {
            exportedRegionFileChooser.showOpenDialog(this.mainFrame);
        }
        this.mainFrame.resetStatusMessage();
        File file = exportedRegionFileChooser.getSelectedFile();
        if (file != null && (directory = exportedRegionFileChooser.getCurrentDirectory()) != null) {
            PreferenceManager.getInstance().setLastExportedRegionDirectory(directory);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info("A blank Region of Interest export file was supplied!");
            return;
        }
        try {
            Collection<RegionOfInterest> regions = IGVMainFrame.getInstance().getSession().getAllRegionsOfInterest();
            if (regions == null || regions.isEmpty()) {
                return;
            }
            roiFile.createNewFile();
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(roiFile);
                for (RegionOfInterest regionOfInterest : regions) {
                    Integer regionStart = regionOfInterest.getStart();
                    if (regionStart == null) continue;
                    Integer regionEnd = regionOfInterest.getEnd();
                    if (regionEnd == null) {
                        regionEnd = regionStart;
                    }
                    writer.print(regionOfInterest.getChr());
                    writer.print("\t");
                    writer.print(regionStart);
                    writer.print("\t");
                    writer.print(regionEnd);
                    if (regionOfInterest.getDescription() != null) {
                        writer.print("\t");
                        writer.println(regionOfInterest.getDescription());
                        continue;
                    }
                    writer.println();
                }
                Object var9_9 = null;
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            log.error("Failed to write Region of Interest export file!", e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Direction {
        IMPORT,
        EXPORT;

    }
}

