/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;

public class LoadFilesMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    IGVMainFrame mainFrame;

    public LoadFilesMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information");
    }

    public void actionPerformed(ActionEvent e2) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                LoadFilesMenuAction.this.loadFiles(LoadFilesMenuAction.this.chooseTrackFiles());
            }
        });
    }

    private File[] chooseTrackFiles() {
        File lastDirectoryFile = PreferenceManager.getInstance().getLastTrackDirectory();
        FileChooserDialog trackFileDialog = this.mainFrame.getTrackFileChooser();
        trackFileDialog.setLocationRelativeTo(this.mainFrame);
        trackFileDialog.setTitle("Select Files");
        trackFileDialog.setMultiSelectionEnabled(true);
        trackFileDialog.setSelectedFile(null);
        trackFileDialog.setCurrentDirectory(lastDirectoryFile);
        trackFileDialog.setFileSelectionMode(0);
        trackFileDialog.setVisible(true);
        File[] trackFiles = null;
        if (!trackFileDialog.isCanceled()) {
            File lastFile = trackFileDialog.getSelectedFile();
            if (lastFile != null && !lastFile.isDirectory()) {
                lastFile = lastFile.getParentFile();
                PreferenceManager.getInstance().setLastTrackDirectory(lastFile);
            }
            trackFiles = trackFileDialog.getSelectedFiles();
            trackFileDialog.setSelectedFile(null);
        }
        this.mainFrame.resetStatusMessage();
        return trackFiles;
    }

    private void loadFiles(File[] files) {
        if (files != null && files.length > 0) {
            ArrayList<File> validFileList = new ArrayList<File>();
            StringBuffer buffer = new StringBuffer();
            buffer.append("File(s) not found: ");
            boolean allFilesExist = true;
            for (File file : files) {
                if (!file.exists()) {
                    allFilesExist = false;
                    buffer.append("\n\t");
                    buffer.append(file.getAbsolutePath());
                    continue;
                }
                String path = file.getAbsolutePath();
                if (path.endsWith(".xml")) {
                    MessageUtils.showAndLogErrorMessage(this.mainFrame, "File " + path + " appears to be an IGV Session file - " + "please use the Open Session menu item " + "to load it.", log);
                    continue;
                }
                validFileList.add(file);
            }
            files = validFileList.toArray(new File[validFileList.size()]);
            if (!allFilesExist) {
                MessageUtils.showAndLogErrorMessage(this.mainFrame, buffer.toString(), log);
            }
            if (files.length > 0) {
                ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>(files.length);
                for (File f2 : files) {
                    locators.add(new ResourceLocator(f2.getAbsolutePath()));
                }
                this.mainFrame.loadTracks(locators);
            }
        }
    }
}

