/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.UIUtilities;

public class ClearGenomeCacheAction
extends MenuAction {
    static Logger logger = Logger.getLogger(ClearGenomeCacheAction.class);

    public ClearGenomeCacheAction(String label) {
        super(label, null);
        this.setToolTipText("Clears locally cached versions of IGV hosted genomes.");
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            int option = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), "Clear the genome cache ?", "Clear the genome cache ?", 0);
            if (option == 0) {
                final String genomeId = ViewContext.getInstance().getGenomeId();
                GenomeManager.getInstance().clearGenomeCache();
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        IGVMainFrame.getInstance().rebuildGenomeDropdownList(null);
                        IGVMainFrame.getInstance().setGenomeId(genomeId);
                    }
                });
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), "Error encontered while removing genomes: " + e2.getMessage());
            logger.error("Error removing genomes from the user-defined genome list.", e2);
        }
    }
}

