/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.broad.igv.util.ColorUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFileBuilder {
    private static Document masterDocument = null;
    private static String DEFAULT_SERVER_URL = "http://www.broadinstitute.org/dataserver/data";
    private static String DEFAULT_OUTPUT_FILE = "tempResourceFile.xml";
    boolean epigenetics;
    Element rootNode = null;

    public void process(File inputDir) {
        try {
            new ResourceFileBuilder().process(inputDir, DEFAULT_OUTPUT_FILE, DEFAULT_SERVER_URL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void process(File inputDir, String outputFile, String serverUrl) throws Exception {
        masterDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.rootNode = masterDocument.createElement("Global");
        this.rootNode.setAttribute("name", "Data");
        this.rootNode.setAttribute("version", "1");
        masterDocument.appendChild(this.rootNode);
        if (this.epigenetics) {
            Object[] files = inputDir.listFiles();
            Arrays.sort(files);
            this.doEpigenetics((File[])files, serverUrl);
        } else {
            this.lookForChildren(inputDir, serverUrl);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(masterDocument);
        transformer.transform(source, streamResult);
        String xmlString = streamResult.getWriter().toString();
        File tempXMLFile = new File(outputFile);
        FileWriter fileWriter = null;
        fileWriter = new FileWriter(tempXMLFile);
        fileWriter.write(xmlString);
        fileWriter.close();
    }

    private void createSampleInfoFiles(File[] files, String sampleInfoFile, String trackPropertiesFile) {
        Arrays.sort(files);
        try {
            PrintWriter sampleInfoWriter = new PrintWriter(new BufferedWriter(new FileWriter(sampleInfoFile)));
            PrintWriter trackWriter = new PrintWriter(new BufferedWriter(new FileWriter(trackPropertiesFile)));
            sampleInfoWriter.println("Name\tCell Type\tMark\t#height\t#renderer\t#color\t#min\t#max");
            for (File file : files) {
                String[] tokens = file.getName().split("\\.");
                if (tokens.length <= 2) continue;
                String trackName = file.getName().replace(".h5", "");
                String cellType = tokens[0].replace("r1", "").replace("r2", "").replace("r3", "");
                String mark = tokens[1];
                sampleInfoWriter.print(trackName + "\t" + cellType + "\t" + mark);
                int min = 0;
                int max = 10;
                String colorString = ColorUtilities.convertColorToRGBString(Color.gray);
                if (mark.toUpperCase().contains("K4")) {
                    max = 25;
                    colorString = "(0,150,0)";
                } else if (mark.toUpperCase().contains("K9")) {
                    colorString = "(100,0,0)";
                } else if (mark.toUpperCase().contains("K27")) {
                    colorString = "(255,0,0)";
                }
                sampleInfoWriter.println("\t40\tBAR_CHART\t" + colorString + "\t" + min + "\t" + max);
            }
            sampleInfoWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doEpigenetics(File[] files, String serverUrl) throws IOException {
        LinkedHashSet<String> cellTypes = new LinkedHashSet<String>();
        LinkedHashSet<String> markers = new LinkedHashSet<String>();
        LinkedHashMap<String, LinkedHashSet<File>> cellMarkerFileMap = new LinkedHashMap<String, LinkedHashSet<File>>();
        for (File file : files) {
            String[] tokens = file.getName().split("\\.");
            if (tokens.length <= 2) continue;
            String cellType = tokens[0];
            String marker = tokens[1];
            cellTypes.add(cellType);
            markers.add(marker);
            String cellMarker = cellType + "." + marker;
            LinkedHashSet<File> cellMarkerFiles = (LinkedHashSet<File>)cellMarkerFileMap.get(cellMarker);
            if (cellMarkerFiles == null) {
                cellMarkerFiles = new LinkedHashSet<File>();
                cellMarkerFileMap.put(cellMarker, cellMarkerFiles);
            }
            cellMarkerFiles.add(file);
        }
        Element cellTypeRootNode = masterDocument.createElement("Category");
        cellTypeRootNode.setAttribute("name", "Cell Type");
        this.rootNode.appendChild(cellTypeRootNode);
        ArrayList sortedCellTypes = new ArrayList(cellTypes);
        Collections.sort(sortedCellTypes);
        ArrayList sortedMarks = new ArrayList(markers);
        Collections.sort(sortedMarks);
        for (String cellType : sortedCellTypes) {
            Element cellTypeNode = masterDocument.createElement("Category");
            cellTypeNode.setAttribute("name", cellType);
            cellTypeRootNode.appendChild(cellTypeNode);
            for (String marker : sortedMarks) {
                String cmKey = cellType + "." + marker;
                this.outputResources(cellMarkerFileMap, serverUrl, cellTypeNode, cmKey);
            }
        }
        Element markerRootNode = masterDocument.createElement("Category");
        markerRootNode.setAttribute("name", "Chromatin Mark");
        this.rootNode.appendChild(markerRootNode);
        for (String marker : sortedMarks) {
            Element markerNode = masterDocument.createElement("Category");
            markerNode.setAttribute("name", marker);
            markerRootNode.appendChild(markerNode);
            for (String cellType : sortedCellTypes) {
                String cmKey = cellType + "." + marker;
                this.outputResources(cellMarkerFileMap, serverUrl, markerNode, cmKey);
            }
        }
    }

    private void outputResources(Map<String, LinkedHashSet<File>> cellMarkerFileMap, String serverUrl, Element cellTypeRootNode, String cmKey) throws IOException, DOMException {
        LinkedHashSet<File> files = cellMarkerFileMap.get(cmKey);
        if (files != null) {
            System.out.println(cmKey + " -> " + files.size());
            if (files.size() > 0) {
                for (File file : files) {
                    String canonicalPath = file.getCanonicalPath();
                    Element resourceNode = masterDocument.createElement("Resource");
                    resourceNode.setAttribute("name", cmKey);
                    resourceNode.setAttribute("path", canonicalPath);
                    resourceNode.setAttribute("serverURL", serverUrl);
                    cellTypeRootNode.appendChild(resourceNode);
                }
            }
        }
    }

    private void lookForChildren(File dir, String serverUrl) throws IOException {
        if (dir.isDirectory()) {
            if (this.rootNode != null) {
                for (File file : dir.listFiles()) {
                    String canonicalPath = file.getCanonicalPath();
                    Element resourceNode = masterDocument.createElement("Resource");
                    resourceNode.setAttribute("name", file.getName());
                    resourceNode.setAttribute("path", canonicalPath);
                    resourceNode.setAttribute("serverURL", serverUrl);
                    this.rootNode.appendChild(resourceNode);
                }
            }
        } else {
            System.err.println("Input must be a directory: " + dir.getAbsolutePath());
        }
    }
}

