/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.broad.igv.ui.UIConstants;

public class MacCompatibleFileChooser {
    static JFileChooser fileChooser;

    public static boolean overwriteFile(Component parent, File f2) {
        if (!f2.exists()) {
            return true;
        }
        String message = "An item named " + f2.getName() + " already exists in this location.\nDo you want to replace it with the one that you are saving?";
        int result = JOptionPane.showConfirmDialog(parent, message, "", 0);
        return result != 1;
    }

    public static File showOpenDialog(Container parent) {
        return MacCompatibleFileChooser.showOpenDialog(parent, null);
    }

    public static File showOpenDialog(Container parent, String title) {
        return MacCompatibleFileChooser.showOpenDialog(parent, title, null);
    }

    public static File showOpenDialog(Container parent, String title, File directory) {
        if (parent == null) {
            parent = JOptionPane.getRootFrame();
        }
        if (UIConstants.IS_MAC && (parent instanceof Frame || parent instanceof Dialog)) {
            return MacCompatibleFileChooser.showAwtFileDialog(parent, 0, directory, title, false);
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if (directory != null) {
            fileChooser.setCurrentDirectory(directory);
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showOpenDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File showSaveDialog(Container parent) {
        return MacCompatibleFileChooser.showSaveDialog(parent, null);
    }

    public static File showSaveDialog(Container parent, File selectedDirectory) {
        return MacCompatibleFileChooser.showSaveDialog(parent, selectedDirectory, null, null, "");
    }

    public static File showSaveDialog(Container parent, File selectedDirectory, File selectedFile, String[] extensions, String dialogTitle) {
        if (UIConstants.IS_MAC && (parent instanceof Frame || parent instanceof Dialog)) {
            return MacCompatibleFileChooser.ensureCorrectExtension(parent, MacCompatibleFileChooser.showAwtFileDialog(parent, 1, selectedDirectory, selectedFile, dialogTitle, false), extensions, true);
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setDialogTitle(dialogTitle);
        if (selectedDirectory != null) {
            fileChooser.setCurrentDirectory(selectedDirectory);
        }
        if (selectedFile != null) {
            fileChooser.setSelectedFile(new File(selectedFile.getName()));
        }
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showSaveDialog(parent) == 0) {
            File outputFile = fileChooser.getSelectedFile();
            if (!MacCompatibleFileChooser.overwriteFile(parent, outputFile = MacCompatibleFileChooser.ensureCorrectExtension(parent, outputFile, extensions, false))) {
                return null;
            }
            return outputFile;
        }
        return null;
    }

    public static File showSelectDirectoryDialog(Container parent, File selectedDirectory, String dialogTitle) {
        if (UIConstants.IS_MAC && (parent instanceof Frame || parent instanceof Dialog)) {
            return MacCompatibleFileChooser.showAwtFileDialog(parent, 1, selectedDirectory, dialogTitle, true);
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(dialogTitle);
        if (selectedDirectory != null) {
            fileChooser.setCurrentDirectory(selectedDirectory);
        }
        if (fileChooser.showOpenDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static File ensureCorrectExtension(Container parent, File file, String[] extensions, boolean prompt) {
        if (file != null && extensions != null) {
            String name = file.getName();
            int length = extensions.length;
            for (int i2 = 0; i2 < length; ++i2) {
                if (!name.toLowerCase().endsWith(extensions[i2].toLowerCase())) continue;
                return file;
            }
            if (extensions.length > 0) {
                name = name + extensions[0];
                file = new File(file.getParent(), name);
                if (prompt && !MacCompatibleFileChooser.overwriteFile(parent, file)) {
                    return null;
                }
                return file;
            }
        }
        return file;
    }

    private static File showAwtFileDialog(Container parent, int mode, File selectedDirectory, String title, boolean directoriesOnly) {
        return MacCompatibleFileChooser.showAwtFileDialog(parent, mode, selectedDirectory, null, title, directoriesOnly);
    }

    private static File showAwtFileDialog(Container parent, int mode, File selectedDirectory, File selectedFile, String title, boolean directoriesOnly) {
        if (directoriesOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        } else {
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
        FileDialog fc = null;
        if (parent instanceof Frame) {
            fc = new FileDialog((Frame)parent, title, mode);
        } else if (parent instanceof Dialog) {
            fc = new FileDialog((Dialog)parent, title, mode);
        } else {
            throw new IllegalArgumentException();
        }
        if (selectedDirectory != null) {
            fc.setDirectory(selectedDirectory.getPath());
        }
        if (selectedFile != null) {
            fc.setFile(selectedFile.getName());
        }
        fc.setModal(true);
        fc.setVisible(true);
        String f2 = fc.getFile();
        String directory = fc.getDirectory();
        if (f2 != null) {
            File file = new File(directory, f2);
            return file;
        }
        return null;
    }

    private MacCompatibleFileChooser() {
    }
}

