/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.combobox.ListComboBox;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.broad.igv.feature.GenomeDescriptor;
import org.jdesktop.layout.GroupLayout;

public class GenomeSelectionDialog
extends JDialog {
    private boolean isCanceled = true;
    private JButton cancelButton;
    private ListComboBox genomeComboBox;
    private JLabel genomeComboBoxLabel;
    private JButton okButton;

    public GenomeSelectionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public void setModel(ComboBoxModel model) {
        this.genomeComboBox.setModel(model);
    }

    public GenomeDescriptor getSelectedItem() {
        return this.isCanceled ? null : (GenomeDescriptor)this.genomeComboBox.getSelectedItem();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCancelingEnabled(boolean isEnabled) {
        this.cancelButton.setEnabled(isEnabled);
    }

    public void setDefaultGenome(GenomeDescriptor genome) {
        this.genomeComboBox.setSelectedItem(genome);
    }

    private void initComponents() {
        this.genomeComboBox = new ListComboBox();
        this.genomeComboBoxLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Choose Genome");
        this.setResizable(false);
        this.genomeComboBox.setEditable(false);
        this.genomeComboBoxLabel.setText("Genome");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenomeSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenomeSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(24, 24, 24).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.genomeComboBoxLabel).add(20, 20, 20).add(this.genomeComboBox, -1, 457, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().addPreferredGap(0, 177, -2).add(this.okButton).addPreferredGap(0).add(this.cancelButton).add(195, 195, 195))).addContainerGap()));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(34, 34, 34).add(layout.createParallelGroup(3).add(this.genomeComboBoxLabel).add(this.genomeComboBox, -2, 23, -2)).add(25, 25, 25).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 2);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GenomeSelectionDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

