/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.track.tribble.Locus;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.util.LineReader;
import org.broad.tribble.util.ParsingUtils;

public class SAMCodec
implements FeatureCodec {
    static final int FLAG_COL = 1;
    static final int READ_UNMAPPED_FLAG = 4;
    private static final int RNAME_COL = 2;
    private static final int POS_COL = 3;
    private static final int CIGAR_COL = 5;
    private static final int NUM_REQUIRED_FIELDS = 11;
    private static String[] fields = new String[11];

    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public synchronized Feature decode(String line) {
        if (line.startsWith("@")) {
            return null;
        }
        int numFields = ParsingUtils.split(line, fields, '\t');
        if (numFields < 11) {
            return null;
        }
        String chr = fields[2];
        int alignmentStart = Integer.parseInt(fields[3].trim());
        String cigarString = fields[5];
        int len = SamUtils.getPaddedReferenceLength(cigarString);
        int alignmentEnd = alignmentStart + len - 1;
        return new Locus(chr, alignmentStart, alignmentEnd);
    }

    public Class getFeatureType() {
        return SAMCodec.class;
    }

    public Object readHeader(LineReader reader) {
        return null;
    }

    boolean isMapped(String[] fields) {
        int flags = Integer.parseInt(fields[1]);
        return (flags & 4) == 0;
    }
}

