/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.tribble.FeatureFileHeader;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.util.LineReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFFCodec
implements FeatureCodec {
    private static Logger log = Logger.getLogger(GFFCodec.class);
    static String[] nameFields = new String[]{"Name", "name", "gene", "primary_name", "Locus", "locus", "alias", "systematic_id", "ID"};
    FeatureFileHeader header;
    Helper helper;
    String[] tokens = new String[10];
    static StringBuffer buf = new StringBuffer();

    public GFFCodec() {
        this.helper = new GFF2Helper();
    }

    public GFFCodec(Version version) {
        this.helper = version == Version.GFF2 ? new GFF2Helper() : new GFF3Helper();
    }

    @Override
    public Object readHeader(LineReader reader) {
        this.header = new FeatureFileHeader();
        int nLines = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null && line.startsWith("#")) {
                String[] kv;
                ++nLines;
                if (line.startsWith("##gff-version") && line.endsWith("3")) {
                    this.helper = new GFF3Helper();
                    continue;
                }
                if (line.startsWith("#track") || line.startsWith("##track")) {
                    TrackProperties trackProperties = new TrackProperties();
                    ParsingUtils.parseTrackLine(line, trackProperties);
                    continue;
                }
                if (line.startsWith("#nodecode") || line.startsWith("##nodecode")) {
                    this.helper.setUrlDecoding(false);
                    continue;
                }
                if (!line.startsWith("#hide") && !line.startsWith("##hide") || (kv = line.split("=")).length <= 1) continue;
                this.header.setFeaturesToHide(Arrays.asList(kv[1].split(",")));
            }
            return this.header;
        }
        catch (IOException e2) {
            throw new CodecLineParsingException("Error parsing header", e2);
        }
    }

    @Override
    public BasicFeature decodeLoc(String line) {
        return this.decode(line);
    }

    public BasicFeature decode(String line) {
        int end;
        int start;
        if (line.startsWith("##gff-version") && line.endsWith("3")) {
            this.helper = new GFF3Helper();
        }
        if (line.startsWith("#")) {
            return null;
        }
        int nTokens = ParsingUtils.split(line, this.tokens, '\t');
        if (nTokens < 9) {
            return null;
        }
        String featureType = new String(this.tokens[2].trim());
        String chromosome = this.tokens[0];
        try {
            start = Integer.parseInt(this.tokens[3]) - 1;
        }
        catch (NumberFormatException ne) {
            throw new DataLoadException("Column 4 must contain a numeric value", line);
        }
        try {
            end = Integer.parseInt(this.tokens[4]);
        }
        catch (NumberFormatException ne) {
            throw new DataLoadException("Column 5 must contain a numeric value", line);
        }
        Strand strand = this.convertStrand(this.tokens[6]);
        String attributeString = this.tokens[8];
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        this.helper.parseAttributes(attributeString, attributes);
        String description = GFFCodec.getDescription(attributes, featureType);
        String id = this.helper.getID(attributes);
        String[] parentIds = this.helper.getParentIds(attributes, attributeString);
        BasicFeature f2 = new BasicFeature(chromosome, start, end, strand);
        f2.setName(this.getName(attributes));
        f2.setType(featureType);
        f2.setDescription(description);
        f2.setIdentifier(id);
        f2.setParentIds(parentIds);
        if (attributes.containsKey("color")) {
            f2.setColor(ColorUtilities.getColorFromString(attributes.get("color")));
        }
        if (attributes.containsKey("Color")) {
            f2.setColor(ColorUtilities.getColorFromString(attributes.get("Color")));
        }
        return f2;
    }

    public Class getFeatureType() {
        return Feature.class;
    }

    public Object getHeader() {
        return this.header;
    }

    private Strand convertStrand(String strandString) {
        Strand strand = Strand.NONE;
        if (strandString.equals("-")) {
            strand = Strand.NEGATIVE;
        } else if (strandString.equals("+")) {
            strand = Strand.POSITIVE;
        }
        return strand;
    }

    String getName(Map<String, String> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return null;
        }
        for (String nf : nameFields) {
            if (!attributes.containsKey(nf)) continue;
            return attributes.get(nf);
        }
        return attributes.values().iterator().next();
    }

    static String getDescription(Map<String, String> attributes, String type) {
        buf.setLength(0);
        buf.append(type);
        buf.append("<br>");
        for (Map.Entry<String, String> att : attributes.entrySet()) {
            String attValue = att.getValue().replaceAll(";", "<br>");
            buf.append(att.getKey());
            buf.append(" = ");
            buf.append(attValue);
            buf.append("<br>");
        }
        String description = buf.toString();
        return description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GFF3Helper
    implements Helper {
        private boolean useUrlDecoding = true;

        GFF3Helper() {
        }

        @Override
        public String[] getParentIds(Map<String, String> attributes, String ignored) {
            String parentIdString = attributes.get("Parent");
            if (parentIdString != null) {
                return attributes.get("Parent").split(",");
            }
            return null;
        }

        @Override
        public void parseAttributes(String description, Map<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tmp = StringUtils.breakQuotedString(kv, '=');
                int nValues = tmp.size();
                if (nValues > 0) {
                    String value;
                    String key = tmp.get(0).trim();
                    String string = value = nValues == 1 ? "" : tmp.get(1).trim();
                    if (this.useUrlDecoding) {
                        key = URLDecoder.decode(key);
                        value = URLDecoder.decode(value);
                    }
                    kvalues.put(key, value);
                    continue;
                }
                log.info("No attributes: " + description);
            }
        }

        @Override
        public void setUrlDecoding(boolean useUrlDecoding) {
            this.useUrlDecoding = useUrlDecoding;
        }

        @Override
        public String getID(Map<String, String> attributes) {
            String id = attributes.get("ID");
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GFF2Helper
    implements Helper {
        String[] idFields = new String[]{"systematic_id", "ID", "Name", "name", "primary_name", "gene", "Locus", "locus", "alias"};

        GFF2Helper() {
        }

        @Override
        public void setUrlDecoding(boolean b2) {
        }

        @Override
        public void parseAttributes(String description, Map<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tokens = StringUtils.breakQuotedString(kv, ' ');
                if (tokens.size() < 2) continue;
                String key = tokens.get(0).trim().replaceAll("\"", "");
                String value = tokens.get(1).trim().replaceAll("\"", "");
                kvalues.put(key, value);
            }
        }

        @Override
        public String[] getParentIds(Map<String, String> attributes, String attributeString) {
            String[] parentIds = new String[1];
            if (attributes.isEmpty()) {
                parentIds[0] = attributeString;
            } else {
                parentIds[0] = attributes.get("id");
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("mRNA");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("systematic_id");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("transcript_id");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("gene");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("transcriptId");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("proteinId");
                }
            }
            return parentIds;
        }

        @Override
        public String getID(Map<String, String> attributes) {
            for (String nf : this.idFields) {
                if (!attributes.containsKey(nf)) continue;
                return attributes.get(nf);
            }
            return GFFCodec.this.getName(attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Helper {
        public String[] getParentIds(Map<String, String> var1, String var2);

        public void parseAttributes(String var1, Map<String, String> var2);

        public String getID(Map<String, String> var1);

        public void setUrlDecoding(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Version {
        GFF2,
        GFF3;

    }
}

