/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.track.tribble.BEDCodec;
import org.broad.igv.track.tribble.GFFCodec;
import org.broad.igv.track.tribble.PSLCodec;
import org.broad.igv.track.tribble.REPMaskCodec;
import org.broad.igv.track.tribble.SAMCodec;
import org.broad.igv.track.tribble.VCFCodec;
import org.broad.tribble.FeatureCodec;

public class CodecFactory {
    public static FeatureCodec getCodec(String file) {
        String fn = file.toLowerCase();
        if (fn.endsWith(".gz")) {
            int l2 = fn.length() - 3;
            fn = fn.substring(0, l2);
        }
        if (fn.endsWith(".vcf") || fn.endsWith(".vcf4")) {
            return new VCFCodec();
        }
        if (fn.endsWith(".bed")) {
            return new BEDCodec();
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec();
        }
        if (fn.endsWith(".repmask")) {
            return new REPMaskCodec();
        }
        if (fn.endsWith(".gff3")) {
            return new GFFCodec(GFFCodec.Version.GFF3);
        }
        if (fn.endsWith(".gff")) {
            return new GFFCodec();
        }
        if (fn.endsWith(".sam")) {
            return new SAMCodec();
        }
        throw new DataLoadException("Unknown file type", file);
    }
}

