/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import org.broad.igv.track.WindowFunction;

public class TrackProperties {
    private BaseCoord baseCoord = BaseCoord.UNSPECIFIED;
    private String name;
    private String description;
    private String url;
    private int height;
    private int minHeight;
    private Color color;
    private Color altColor;
    private Color midColor;
    private String genome;
    private int offset;
    private boolean autoScaleFlag = false;
    private float minValue = Float.NaN;
    private float maxValue = Float.NaN;
    private float midValue = Float.NaN;
    private float neutralFromValue = Float.NaN;
    private float neutralToValue = Float.NaN;
    private boolean drawMidValue = true;
    private Class rendererClass;
    private WindowFunction windowingFunction;
    private int smoothingWindow;
    private boolean itemRGB = true;
    private boolean useScore = false;
    private int featureVisibilityWindow = -1;
    private boolean logScale;

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public int getFeatureVisibilityWindow() {
        return this.featureVisibilityWindow;
    }

    public void setFeatureVisibilityWindow(int featureVisibilityWindow) {
        this.featureVisibilityWindow = featureVisibilityWindow;
    }

    public boolean isUseScore() {
        return this.useScore;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public boolean isItemRGB() {
        return this.itemRGB;
    }

    public void setItemRGB(boolean itemRGB) {
        this.itemRGB = itemRGB;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getAltColor() {
        return this.altColor;
    }

    public void setAltColor(Color altColor) {
        this.altColor = altColor;
    }

    public boolean isAutoScale() {
        return this.autoScaleFlag || Float.isNaN(this.minValue) || Float.isNaN(this.maxValue);
    }

    public String getGenome() {
        return this.genome;
    }

    public void setGenome(String genome) {
        this.genome = genome;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public WindowFunction getWindowingFunction() {
        return this.windowingFunction;
    }

    public void setWindowingFunction(WindowFunction windowingFunction) {
        this.windowingFunction = windowingFunction;
    }

    public int getSmoothingWindow() {
        return this.smoothingWindow;
    }

    public void setSmoothingWindow(int smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
    }

    public Class getRendererClass() {
        return this.rendererClass;
    }

    public void setRendererClass(Class rendererClass) {
        this.rendererClass = rendererClass;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScaleFlag = autoScale;
    }

    public float getMidValue() {
        return this.midValue;
    }

    public void setMidValue(float midValue) {
        this.midValue = midValue;
    }

    public Color getMidColor() {
        return this.midColor;
    }

    public void setMidColor(Color midColor) {
        this.midColor = midColor;
    }

    public boolean isDrawMidValue() {
        return this.drawMidValue;
    }

    public void setDrawMidValue(boolean drawMidValue) {
        this.drawMidValue = drawMidValue;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public BaseCoord getBaseCoord() {
        return this.baseCoord;
    }

    public void setBaseCoord(BaseCoord baseCoord) {
        this.baseCoord = baseCoord;
    }

    public float getNeutralFromValue() {
        return this.neutralFromValue;
    }

    public void setNeutralFromValue(float neutralFromValue) {
        this.neutralFromValue = neutralFromValue;
    }

    public float getNeutralToValue() {
        return this.neutralToValue;
    }

    public void setNeutralToValue(float neutralToValue) {
        this.neutralToValue = neutralToValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseCoord {
        ZERO,
        ONE,
        UNSPECIFIED;

    }
}

