/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.broad.igv.feature.Feature;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneTrack
implements Track {
    SequenceTrack sequenceTrack;
    FeatureTrack featureTrack;

    public GeneTrack(FeatureTrack featureTrack, SequenceTrack sequenceTrack) {
        this.featureTrack = featureTrack;
        this.sequenceTrack = sequenceTrack;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight = this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += seqHeight;
        rect.height -= seqHeight;
        this.featureTrack.render(context, rect);
    }

    @Override
    public void renderBorder(RenderContext context, Rectangle rect) {
        int seqHeight = this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.renderBorder(context, seqRect);
        }
        rect.y += seqHeight;
        rect.height -= seqHeight;
        this.featureTrack.renderBorder(context, rect);
    }

    @Override
    public void renderAxis(RenderContext context, Rectangle rect) {
        int seqHeight = this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.renderAxis(context, seqRect);
        }
        rect.y += seqHeight;
        rect.height -= seqHeight;
        this.featureTrack.renderAxis(context, rect);
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        this.featureTrack.render(context, rect);
        this.sequenceTrack.render(context, rect);
    }

    @Override
    public String getId() {
        return this.featureTrack.getId();
    }

    @Override
    public String getName() {
        return this.featureTrack.getName();
    }

    @Override
    public String getSampleId() {
        return this.featureTrack.getSampleId();
    }

    public String getDisplayName() {
        return this.featureTrack.getName();
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.featureTrack.getResourceLocator();
    }

    @Override
    public void setAttributeValue(String key, String value) {
        this.featureTrack.setAttributeValue(key, value);
    }

    @Override
    public String getAttributeValue(String attributeKey) {
        return this.featureTrack.getAttributeValue(attributeKey);
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.featureTrack.setVisible(isVisible);
        this.sequenceTrack.setVisible(isVisible);
    }

    @Override
    public boolean isVisible() {
        return this.featureTrack.isVisible() || this.sequenceTrack.isVisible();
    }

    @Override
    public void setTrackType(TrackType type) {
        this.featureTrack.setTrackType(type);
    }

    @Override
    public TrackType getTrackType() {
        return this.featureTrack.getTrackType();
    }

    @Override
    public void setHeight(int preferredHeight) {
        this.featureTrack.setHeight(preferredHeight);
    }

    @Override
    public int getHeight() {
        return this.featureTrack.getHeight() + this.sequenceTrack.getHeight();
    }

    @Override
    public int getMinimumHeight() {
        return this.featureTrack.getMinimumHeight() + this.sequenceTrack.getMinimumHeight();
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.featureTrack.setDataRange(axisDefinition);
    }

    @Override
    public DataRange getDataRange() {
        return this.featureTrack.getDataRange();
    }

    @Override
    public Color getColor() {
        return this.featureTrack.getColor();
    }

    @Override
    public Color getAltColor() {
        return this.featureTrack.getAltColor();
    }

    @Override
    public Color getMidColor() {
        return this.featureTrack.getMidColor();
    }

    @Override
    public void setColor(Color color) {
        this.featureTrack.setColor(color);
    }

    @Override
    public void setAltColor(Color color) {
        this.featureTrack.setAltColor(color);
    }

    @Override
    public void setMidColor(Color color) {
        this.featureTrack.setMidColor(color);
    }

    @Override
    public void setStatType(WindowFunction type) {
        this.featureTrack.setStatType(type);
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.featureTrack.getWindowFunction();
    }

    @Override
    public void setRendererClass(Class rc) {
        this.featureTrack.setRendererClass(rc);
    }

    @Override
    public Renderer getRenderer() {
        return this.featureTrack.getRenderer();
    }

    @Override
    public void setSelected(boolean selected) {
        this.featureTrack.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this.featureTrack.isSelected();
    }

    @Override
    public boolean isDraggable() {
        return this.featureTrack.isDraggable();
    }

    @Override
    public boolean isLogNormalized() {
        return this.featureTrack.isLogNormalized();
    }

    @Override
    public boolean isShowDataRange() {
        return this.featureTrack.isShowDataRange();
    }

    @Override
    public String getValueStringAt(String chr, double position, int y) {
        return this.featureTrack.getValueStringAt(chr, position, y);
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        return this.featureTrack.getRegionScore(chr, start, end, zoom, type);
    }

    @Override
    public void refreshData(long timestamp) {
        this.featureTrack.refreshData(timestamp);
    }

    @Override
    public void setFontSize(int h2) {
        this.featureTrack.setFontSize(h2);
    }

    @Override
    public int getFontSize() {
        return this.featureTrack.getFontSize();
    }

    @Override
    public void setSourceFile(String filename) {
        this.featureTrack.setSourceFile(filename);
    }

    @Override
    public String getSourceFile() {
        return this.featureTrack.getSourceFile();
    }

    @Override
    public void setExpanded(boolean value) {
        this.featureTrack.setExpanded(value);
    }

    @Override
    public boolean isExpanded() {
        return this.featureTrack.isExpanded();
    }

    @Override
    public boolean handleClick(MouseEvent e2) {
        return this.featureTrack.handleClick(e2);
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.featureTrack.getAvailableWindowFunctions();
    }

    @Override
    public void setTrackProperties(TrackProperties trackProperties) {
        this.featureTrack.setTrackProperties(trackProperties);
    }

    @Override
    public void setOverlayVisible(boolean overlayVisible) {
        this.featureTrack.setOverlayVisible(overlayVisible);
    }

    @Override
    public void setName(String name) {
        this.featureTrack.setName(name);
    }

    @Override
    public void setUrl(String url) {
        this.featureTrack.setUrl(url);
    }

    public void preloadData(String chr, int start, int end, int zoom) {
        this.featureTrack.preloadData(chr, start, end, zoom);
    }

    @Override
    public Feature getFeatureAtMousePosition(MouseEvent e2) {
        return this.featureTrack.getFeatureAtMousePosition(e2);
    }

    @Override
    public String getId_142() {
        return this.featureTrack.getId_142();
    }

    @Override
    public void setSampleId(String sampleId) {
        this.featureTrack.setSampleId(sampleId);
    }

    @Override
    public float logScaleData(float dataY) {
        return this.featureTrack.logScaleData(dataY);
    }

    @Override
    public Map<String, String> getPersistentState() {
        return this.featureTrack.getPersistentState();
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        this.featureTrack.restorePersistentState(attributes);
    }

    public String getUrl() {
        return this.featureTrack.getUrl();
    }

    @Override
    public void renderName(Graphics2D graphics, Rectangle rect, Rectangle visibleRect) {
        this.featureTrack.renderName(graphics, rect, visibleRect);
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public void setTop(int top) {
        this.featureTrack.setTop(top);
    }

    @Override
    public int getTop() {
        return this.featureTrack.getTop();
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        this.featureTrack.setColorScale(colorScale);
    }

    @Override
    public ContinuousColorScale getColorScale() {
        return this.featureTrack.getColorScale();
    }

    public Feature nextFeature(String chr, double center, boolean forward) throws IOException {
        return this.featureTrack.nextFeature(chr, center, forward);
    }
}

