/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(DataTrack.class);
    private DataRenderer renderer;
    private boolean autoscale = PreferenceManager.getInstance().getChartPreferences().isAutoscale();

    public DataTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
    }

    public boolean isAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(boolean autoscale) {
        this.autoscale = autoscale;
    }

    @Override
    public void preloadData(String chrName, int start, int end, int zoom) {
        this.getSummaryScores(chrName, start, end, zoom);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        List<LocusScore> scores;
        List<LocusScore> inViewScores = scores = this.getSummaryScores(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation() + 1, context.getZoom());
        if (this.autoscale) {
            double origin = context.getOrigin();
            double end = origin + context.getScale() * (double)rect.width;
            InViewInterval inter = this.computeScale(origin, end, scores);
            if (inter.endIdx > inter.startIdx) {
                inViewScores = scores.subList(inter.startIdx, inter.endIdx);
                DataRange dr = this.getDataRange();
                float min = Math.min(0.0f, inter.dataMin);
                float base = Math.max(min, dr.getBaseline());
                float max = inter.dataMax;
                if (max - min <= 2.8E-45f) {
                    max = min + 1.0f;
                }
                DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                newDR.setType(dr.getType());
                this.setDataRange(newDR);
            }
        }
        this.getRenderer().render(this, inViewScores, context, rect);
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (DataRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error("Error instatiating renderer ", ex);
        }
    }

    @Override
    public DataRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(this.getDefaultRendererClass());
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y) {
        LocusScore score;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName() + "<br>");
        if (this.getDataRange() != null && this.getRenderer() instanceof XYPlotRenderer) {
            buf.append("Data scale: " + this.getDataRange().getMinimum() + " - " + this.getDataRange().getMaximum() + "<br>");
        }
        buf.append((score = this.getLocusScoreAt(chr, position)) == null ? "" : score.getValueString(position, this.getWindowFunction()));
        return buf.toString();
    }

    public LocusScore getLocusScoreAt(String chr, double position) {
        int zoom = Math.max(0, ViewContext.getInstance().getZoom());
        List<LocusScore> scores = this.getSummaryScores(chr, (int)position - 10, (int)position + 10, zoom);
        double bpPerPixel = ViewContext.getInstance().getScale();
        double minWidth = 2.0 * bpPerPixel;
        if (scores == null) {
            return null;
        }
        return FeatureUtils.getFeatureAt(position, minWidth, scores);
    }

    public abstract List<LocusScore> getSummaryScores(String var1, int var2, int var3, int var4);

    public boolean handleClick(int x, int y) {
        return false;
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
    }

    @Override
    public void setAltColor(Color color) {
        super.setAltColor(color);
    }

    @Override
    public void setMidColor(Color color) {
        super.setMidColor(color);
    }

    public boolean isRegionScoreType(RegionScoreType type) {
        return this.getTrackType() == TrackType.GENE_EXPRESSION && type == RegionScoreType.EXPRESSION || (this.getTrackType() == TrackType.COPY_NUMBER || this.getTrackType() == TrackType.CNV || this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER) && (type == RegionScoreType.AMPLIFICATION || type == RegionScoreType.DELETION || type == RegionScoreType.FLUX) || type == RegionScoreType.SCORE;
    }

    private InViewInterval computeScale(double origin, double end, List<LocusScore> scores) {
        InViewInterval interval = new InViewInterval();
        if (scores.size() == 1) {
            interval.dataMax = Math.max(0.0f, scores.get(0).getScore());
            interval.dataMin = Math.min(0.0f, scores.get(0).getScore());
        } else {
            int i2;
            interval.startIdx = 0;
            interval.endIdx = scores.size();
            for (i2 = 1; i2 < scores.size(); ++i2) {
                if (!((double)scores.get(i2).getEnd() >= origin)) continue;
                interval.startIdx = i2 - 1;
                break;
            }
            for (i2 = interval.startIdx + 1; i2 < scores.size(); ++i2) {
                LocusScore locusScore = scores.get(i2);
                interval.dataMax = Math.max(interval.dataMax, locusScore.getScore());
                interval.dataMin = Math.min(interval.dataMin, locusScore.getScore());
                if (!((double)locusScore.getStart() > end)) continue;
                interval.endIdx = i2;
                break;
            }
        }
        return interval;
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> properties = super.getPersistentState();
        properties.put("autoscale", String.valueOf(this.autoscale));
        return properties;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String as = attributes.get("autoscale");
        if (as != null) {
            try {
                this.autoscale = Boolean.parseBoolean(as);
            }
            catch (Exception e2) {
                log.error("Error restoring session.  Invalid autoscale value: " + this.autoscale);
            }
        }
    }

    class InViewInterval {
        int startIdx;
        int endIdx;
        float dataMax = 0.0f;
        float dataMin = 0.0f;

        InViewInterval() {
        }
    }
}

