/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.h5.ObjectNotFoundException;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceTrack
extends DataTrack {
    private DataSource dataSource;
    public static double log2 = Math.log(2.0);

    public DataSourceTrack(ResourceLocator locator, String id, String name, DataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
        this.setTrackType(dataSource.getTrackType());
        float min = (float)dataSource.getDataMin();
        float max = (float)dataSource.getDataMax();
        float baseline = 0.0f;
        if (min > 0.0f) {
            min = 0.0f;
        }
        this.setDataRange(new DataRange(min, baseline, max));
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        try {
            ArrayList tmp = this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
            return tmp == null ? new ArrayList() : tmp;
        }
        catch (ObjectNotFoundException ex) {
            return new ArrayList<LocusScore>();
        }
    }

    @Override
    public void setStatType(WindowFunction statType) {
        this.dataSource.setWindowFunction(statType);
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource.isLogNormalized();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        if (end <= start) {
            return 0.0f;
        }
        if (this.isRegionScoreType(type)) {
            List<LocusScore> scores = this.getSummaryScores(chr, start, end, zoom);
            if (type == RegionScoreType.FLUX) {
                float sumDiffs = 0.0f;
                float lastScore = Float.NaN;
                for (LocusScore score : scores) {
                    if (score.getEnd() < start || score.getStart() > end) continue;
                    if (Float.isNaN(lastScore)) {
                        lastScore = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                        continue;
                    }
                    float s = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                    sumDiffs += Math.abs(s - lastScore);
                    lastScore = s;
                }
                return sumDiffs;
            }
            float regionScore = 0.0f;
            int intervalSum = 0;
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                regionScore += value * (float)interval;
                intervalSum += interval;
            }
            if (intervalSum <= 0) {
                return -3.4028235E38f;
            }
            return type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum);
        }
        return -3.4028235E38f;
    }

    @Override
    public void refreshData(long timestamp) {
        this.dataSource.refreshData(timestamp);
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource.getWindowFunction();
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.dataSource.getAvailableWindowFunctions();
    }
}

