/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.RendererFactory;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrack
implements Track {
    private static Logger log = Logger.getLogger(AbstractTrack.class);
    public static final String COLOR_ATTR_KEY = "#COLOR";
    public static final String ALT_COLOR_ATTR_KEY = "#ALTCOLOR";
    public static final String DATA_MID_ATTR_KEY = "#MID";
    public static final String DATA_MAX_ATTR_KEY = "#MAX";
    public static final String DATA_MIN_ATTR_KEY = "#MIN";
    public static final String HEIGHT_ATTR_KEY = "#HEIGHT";
    public static final String RENDERER_ATTR_KEY = "#GRAPHTYPE";
    private static Class defaultRendererClass = BarChartRenderer.class;
    private static Map<TrackType, Class> defaultRendererMap = new HashMap<TrackType, Class>();
    private String id;
    private String id_142;
    private String name;
    private Color midColor;
    private String url;
    private boolean itemRGB = true;
    private boolean useScore;
    private float viewLimitMin;
    private float viewLimitMax;
    private int fontSize = 9;
    private boolean showDataRange = true;
    private String sampleId;
    private String sourceFile = "";
    private int top;
    private int minimumHeight = 1;
    private ResourceLocator resourceLocator;
    private TrackType trackType = TrackType.OTHER;
    private boolean isSelected = false;
    private boolean visible = true;
    boolean overlayVisible;
    private int preferredHeight;
    private boolean isDraggable = true;
    private Map<String, String> attributes = new HashMap<String, String>();
    private ContinuousColorScale colorScale;
    private Color posColor;
    private Color altColor;
    private DataRange dataRange;
    int height = -1;
    boolean expanded = false;

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public AbstractTrack(ResourceLocator dataResourceLocator, String id, String name) {
        this.resourceLocator = dataResourceLocator;
        this.id = id;
        this.name = name;
        this.init();
    }

    public AbstractTrack(ResourceLocator dataResourceLocator) {
        this.resourceLocator = dataResourceLocator;
        this.id = dataResourceLocator.getPath();
        String drName = dataResourceLocator.getName();
        this.name = drName != null ? drName : dataResourceLocator.getFileName();
        this.init();
    }

    public AbstractTrack(String id) {
        this.name = id;
        this.id = id;
        this.init();
    }

    public AbstractTrack(String id, String name) {
        this.name = name;
        this.id = id;
        this.init();
    }

    private void init() {
        this.overlayVisible = IGVMainFrame.getInstance().getSession().getDisplayOverlayTracks();
        this.showDataRange = PreferenceManager.getInstance().getChartPreferences().isShowDataRange();
        this.id_142 = String.valueOf(this.name == null ? this.resourceLocator.getPath() : this.name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void preloadData(String chr, int start, int end, int zoom) {
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String getDisplayName() {
        String name;
        String sampleKey = IGVMainFrame.getInstance().getSession().getTrackAttributeName();
        if (sampleKey != null && sampleKey.trim().length() > 0 && (name = this.getAttributeValue(sampleKey.trim())) != null) {
            return name;
        }
        return this.getName();
    }

    @Override
    public String getSampleId() {
        if (this.sampleId != null) {
            return this.sampleId;
        }
        return this.getName();
    }

    @Override
    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    @Override
    public void renderBorder(RenderContext context, Rectangle rect) {
        Renderer renderer = this.getRenderer();
        if (renderer != null) {
            this.getRenderer().renderBorder(this, context, rect);
        }
    }

    @Override
    public void renderAxis(RenderContext context, Rectangle rect) {
        Renderer renderer = this.getRenderer();
        if (renderer != null) {
            this.getRenderer().renderAxis(this, context, rect);
        }
    }

    @Override
    public void renderName(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Rectangle rect = this.getDisplayableRect(trackRectangle, visibleRectangle);
        String trackName = this.getDisplayName();
        if (trackName != null) {
            if (this.isSelected()) {
                graphics.setBackground(Color.LIGHT_GRAY);
            } else {
                graphics.setBackground(Color.WHITE);
            }
            Graphics2D g2D = graphics;
            g2D.clearRect(rect.x, rect.y, rect.width, rect.height);
            if (rect.getHeight() > 3.0) {
                int gap = Math.min(4, rect.height / 3);
                int fontSize = Math.min(12, rect.height - gap);
                Font font = FontManager.getScalableFont(fontSize);
                g2D.setFont(font);
                FontManager.applyScalableTextHints(g2D);
                GraphicUtils.drawWrappedText(trackName, rect, g2D, false);
            }
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
    }

    @Override
    public Color getColor() {
        if (this.posColor != null) {
            return this.posColor;
        }
        return this.getRenderer() == null ? null : this.getRenderer().getDefaultColor();
    }

    @Override
    public Color getAltColor() {
        return this.altColor;
    }

    private Color getColorAttribute(String key, Color defaultValue) {
        String rgb = this.getAttributeValue(key);
        if (rgb != null) {
            try {
                return ColorUtilities.convertRGBStringToColor(rgb.replace("\"", ""));
            }
            catch (Exception exception) {
                log.info("Invalid color string " + rgb + " for track: " + this.getName());
            }
        }
        return defaultValue;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Override
    public void setAttributeValue(String key, String value) {
        String uppercaseKey = key.toUpperCase();
        this.attributes.put(uppercaseKey, value);
        AttributeManager.getInstance().addAttributeKey(uppercaseKey);
    }

    @Override
    public String getAttributeValue(String attributeKey) {
        String value = this.attributes.get(attributeKey);
        if (value == null) {
            value = AttributeManager.getInstance().getAttribute(this.getName(), attributeKey);
        }
        return value;
    }

    public int getLevelNumber(int y) {
        return this.preferredHeight == 0 ? 0 : y / this.preferredHeight;
    }

    private int getDefaultHeight() {
        if (XYPlotRenderer.class.isAssignableFrom(this.getDefaultRendererClass())) {
            return PreferenceManager.getInstance().getDefaultChartTrackHeight();
        }
        return PreferenceManager.getInstance().getDefaultTrackHeight();
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    @Override
    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    @Override
    public void setTrackType(TrackType type) {
        this.trackType = type;
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType;
    }

    protected ViewContext getViewContext() {
        return ViewContext.getInstance();
    }

    @Override
    public boolean isVisible() {
        return this.visible && (this.getTrackType() != UIConstants.overlayTrackType || this.overlayVisible);
    }

    @Override
    public void setColor(Color color) {
        this.posColor = color;
    }

    @Override
    public void setAltColor(Color color) {
        this.altColor = color;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    @Override
    public void setOverlayVisible(boolean bool) {
        this.overlayVisible = bool;
    }

    public void updateState() {
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public void setIsDraggable(boolean value) {
        this.isDraggable = value;
    }

    @Override
    public boolean isDraggable() {
        return this.isDraggable;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height < 0 ? this.getDefaultHeight() : this.height;
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public DataRange getDataRange() {
        if (this.dataRange == null) {
            float min = (float)(this.colorScale == null ? 0.0 : this.colorScale.getMinimum());
            float max = (float)(this.colorScale == null ? 10.0 : this.colorScale.getMaximum());
            float baseline = (float)(this.colorScale == null ? 0.0 : (this.colorScale.getNegStart() + this.colorScale.getPosStart()) / 2.0);
            this.setDataRange(new DataRange(min, baseline, max));
        }
        return this.dataRange;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.dataRange = axisDefinition;
    }

    protected Class getDefaultRendererClass() {
        Class def = defaultRendererMap.get((Object)this.getTrackType());
        return def == null ? defaultRendererClass : def;
    }

    protected LocusScore getFeatureAt(double position, double minWidth, List<? extends LocusScore> features) {
        return FeatureUtils.getFeatureAt(position, minWidth, features);
    }

    @Override
    public void refreshData(long timestamp) {
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public Color getMidColor() {
        return this.midColor;
    }

    @Override
    public void setMidColor(Color midColor) {
        this.midColor = midColor;
    }

    @Override
    public boolean handleClick(MouseEvent e2) {
        return false;
    }

    @Override
    public void setTrackProperties(TrackProperties trackProperties) {
        this.itemRGB = trackProperties.isItemRGB();
        this.useScore = trackProperties.isUseScore();
        this.viewLimitMin = trackProperties.getMinValue();
        this.viewLimitMax = trackProperties.getMaxValue();
        if (!Float.isNaN(this.viewLimitMin) && !Float.isNaN(this.viewLimitMax) && this instanceof DataTrack) {
            ((DataTrack)this).setAutoscale(false);
        }
        if (!(trackProperties.isAutoScale() || Float.isNaN(trackProperties.getMinValue()) || Float.isNaN(trackProperties.getMaxValue()))) {
            float min = trackProperties.getMinValue();
            float max = trackProperties.getMaxValue();
            float mid = trackProperties.getMidValue();
            if (Float.isNaN(mid)) {
                mid = min >= 0.0f ? Math.max(min, 0.0f) : Math.min(max, 0.0f);
            }
            DataRange dr = new DataRange(min, mid, max);
            this.setDataRange(dr);
            if (trackProperties.isLogScale()) {
                dr.setType(DataRange.Type.LOG);
            }
            Color maxColor = trackProperties.getColor();
            Color minColor = trackProperties.getAltColor();
            if (maxColor != null && minColor != null) {
                float tmp = trackProperties.getNeutralFromValue();
                float neutralFrom = Float.isNaN(tmp) ? mid : tmp;
                tmp = trackProperties.getNeutralToValue();
                float neutralTo = Float.isNaN(tmp) ? mid : tmp;
                Color midColor = trackProperties.getMidColor();
                if (midColor == null) {
                    midColor = Color.white;
                }
                this.colorScale = new ContinuousColorScale(neutralFrom, min, neutralTo, max, minColor, midColor, maxColor);
            }
        }
        if (trackProperties.getName() != null) {
            this.name = trackProperties.getName();
        }
        if (trackProperties.getColor() != null) {
            this.setColor(trackProperties.getColor());
        }
        if (trackProperties.getAltColor() != null) {
            this.setAltColor(trackProperties.getAltColor());
        }
        if (trackProperties.getMidColor() != null) {
            this.setMidColor(trackProperties.getMidColor());
        }
        if (trackProperties.getHeight() > 0) {
            this.setHeight(trackProperties.getHeight());
        }
        if (trackProperties.getMinHeight() > 0) {
            this.setMinimumHeight(trackProperties.getMinHeight());
        }
        if (trackProperties.getRendererClass() != null) {
            this.setRendererClass(trackProperties.getRendererClass());
        }
        if (trackProperties.getWindowingFunction() != null) {
            this.setStatType(trackProperties.getWindowingFunction());
        }
        if (trackProperties.getUrl() != null) {
            this.setUrl(trackProperties.getUrl());
        }
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    public void setTop(int top) {
        this.top = top;
    }

    @Override
    public ContinuousColorScale getColorScale() {
        if (this.colorScale == null) {
            ContinuousColorScale defaultScale = IGVMainFrame.getInstance().getSession().getColorScale(this.trackType);
            if (defaultScale != null) {
                return defaultScale;
            }
            double min = this.dataRange == null ? 0.0 : (double)this.dataRange.getMinimum();
            double max = this.dataRange == null ? 10.0 : (double)this.dataRange.getMaximum();
            Color c2 = this.getColor();
            Color minColor = Color.white;
            if (min < 0.0) {
                minColor = this.altColor == null ? this.oppositeColor(minColor) : this.altColor;
                this.colorScale = new ContinuousColorScale(min, 0.0, max, minColor, Color.white, c2);
            } else {
                this.colorScale = new ContinuousColorScale(min, max, minColor, c2);
            }
            this.colorScale.setNoDataColor(UIConstants.NO_DATA_COLOR);
        }
        return this.colorScale;
    }

    private Color oppositeColor(Color c2) {
        float[] rgb = new float[4];
        c2.getRGBComponents(rgb);
        rgb[0] = Math.abs(rgb[0] - 255.0f);
        rgb[1] = Math.abs(rgb[1] - 255.0f);
        rgb[2] = Math.abs(rgb[2] - 255.0f);
        return Color.getHSBColor(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public Map<String, String> getPersistentState() {
        WindowFunction wf;
        RendererFactory.RendererType type;
        Renderer renderer;
        Color color;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (this.colorScale != null && !this.colorScale.isDefault()) {
            attributes.put(SessionReader.SessionAttribute.COLOR_SCALE.getText(), this.colorScale.asString());
        }
        attributes.put("showDataRange", String.valueOf(this.showDataRange));
        attributes.put(SessionReader.SessionAttribute.VISIBLE.getText(), String.valueOf(this.isVisible()));
        attributes.put(SessionReader.SessionAttribute.EXPAND.getText(), String.valueOf(this.isExpanded()));
        int height = this.getHeight();
        if (this instanceof FeatureTrack && this.isExpanded()) {
            height /= ((FeatureTrack)this).getNumberOfFeatureLevels();
        }
        String value = Integer.toString(height);
        attributes.put(SessionReader.SessionAttribute.HEIGHT.getText(), value);
        if (this.name != null) {
            attributes.put(SessionReader.SessionAttribute.NAME.getText(), this.name);
        }
        if ((color = this.getColor()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(color.getRed());
            stringBuffer.append(",");
            stringBuffer.append(color.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(color.getBlue());
            attributes.put(SessionReader.SessionAttribute.COLOR.getText(), stringBuffer.toString());
        }
        if ((renderer = this.getRenderer()) != null && (type = RendererFactory.getRenderType(renderer)) != null) {
            attributes.put(SessionReader.SessionAttribute.RENDERER.getText(), type.name());
        }
        if ((wf = this.getWindowFunction()) != null) {
            attributes.put(SessionReader.SessionAttribute.WINDOW_FUNCTION.getText(), wf.name());
        }
        if (this instanceof FeatureTrack) {
            boolean expand = this.isExpanded();
            attributes.put(SessionReader.SessionAttribute.EXPAND.getText(), String.valueOf(expand));
        }
        attributes.put("fontSize", String.valueOf(this.getFontSize()));
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        Class rendererClass;
        ColorScale cs;
        String displayName = attributes.get(SessionReader.SessionAttribute.DISPLAY_NAME.getText());
        String name = attributes.get(SessionReader.SessionAttribute.NAME.getText());
        String isVisible = attributes.get(SessionReader.SessionAttribute.VISIBLE.getText());
        String height = attributes.get(SessionReader.SessionAttribute.HEIGHT.getText());
        String color = attributes.get(SessionReader.SessionAttribute.COLOR.getText());
        String rendererType = attributes.get(SessionReader.SessionAttribute.RENDERER.getText());
        String windowFunction = attributes.get(SessionReader.SessionAttribute.WINDOW_FUNCTION.getText());
        String scale = attributes.get(SessionReader.SessionAttribute.SCALE.getText());
        String isExpanded = attributes.get(SessionReader.SessionAttribute.EXPAND.getText());
        String colorScale = attributes.get(SessionReader.SessionAttribute.COLOR_SCALE.getText());
        String fontSizeString = attributes.get("fontSize");
        String showDataRangeString = attributes.get("showDataRange");
        if (colorScale != null && (cs = ColorScaleFactory.getScaleFromString(colorScale)) instanceof ContinuousColorScale) {
            this.setColorScale((ContinuousColorScale)cs);
        }
        if (name != null && name.length() > 0) {
            this.setName(name);
        } else if (displayName != null && displayName.length() > 0) {
            this.setName(displayName);
        }
        if (isVisible != null) {
            if (isVisible.equalsIgnoreCase("true")) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
        if (showDataRangeString != null) {
            try {
                this.showDataRange = Boolean.parseBoolean(showDataRangeString);
            }
            catch (Exception e2) {
                log.error("Error parsing data range: " + showDataRangeString);
            }
        }
        if (height != null) {
            try {
                this.setHeight(Integer.parseInt(height));
            }
            catch (NumberFormatException e3) {
                log.error("Error restoring track height: " + height);
            }
        }
        if (fontSizeString != null) {
            try {
                this.setFontSize(Integer.parseInt(fontSizeString));
            }
            catch (NumberFormatException e4) {
                log.error("Error restoring font size: " + fontSizeString);
            }
        }
        if (color != null) {
            String[] rgb = color.split(",");
            int red = Integer.parseInt(rgb[0]);
            int green = Integer.parseInt(rgb[1]);
            int blue = Integer.parseInt(rgb[2]);
            this.setColor(new Color(red, green, blue));
        }
        if (rendererType != null && (rendererClass = RendererFactory.getRendererClass(rendererType)) != null) {
            this.setRendererClass(rendererClass);
        }
        if (windowFunction != null) {
            this.setStatType(WindowFunction.getWindowFunction(windowFunction));
        }
        if (scale != null) {
            String[] axis = scale.split(",");
            float minimum = Float.parseFloat(axis[0]);
            float baseline = Float.parseFloat(axis[1]);
            float maximum = Float.parseFloat(axis[2]);
            this.setDataRange(new DataRange(minimum, baseline, maximum));
        }
        if (isExpanded != null) {
            this.setExpanded(isExpanded.equalsIgnoreCase("true"));
        }
    }

    public boolean isItemRGB() {
        return this.itemRGB;
    }

    public boolean isUseScore() {
        return this.useScore;
    }

    public float getViewLimitMin() {
        return this.viewLimitMin;
    }

    public float getViewLimitMax() {
        return this.viewLimitMax;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public boolean isShowDataRange() {
        return this.showDataRange;
    }

    public void setShowDataRange(boolean showDataRange) {
        this.showDataRange = showDataRange;
    }

    @Override
    public Feature getFeatureAtMousePosition(MouseEvent e2) {
        return null;
    }

    @Override
    public String getId_142() {
        return this.id_142 == null ? this.getName() : this.id_142;
    }

    public void setId_142(String id_142) {
        this.id_142 = id_142;
    }

    public static float getLogNormalizedValue(float value, double norm) {
        if (norm == 0.0) {
            return Float.NaN;
        }
        return (float)(Math.log((double)Math.max(Float.MIN_VALUE, value) / norm) / DataSourceTrack.log2);
    }

    @Override
    public float logScaleData(float dataY) {
        if (!(this.getTrackType() != TrackType.COPY_NUMBER && this.getTrackType() != TrackType.ALLELE_SPECIFIC_COPY_NUMBER && this.getTrackType() != TrackType.CNV || this.isLogNormalized())) {
            double centerValue = this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER ? 1.0 : 2.0;
            dataY = AbstractTrack.getLogNormalizedValue(dataY, centerValue);
        }
        return dataY;
    }

    static {
        defaultRendererMap.put(TrackType.RNAI, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.CNV, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.ALLELE_SPECIFIC_COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.GENE_EXPRESSION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.DNA_METHYLATION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.LOH, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.OTHER, BarChartRenderer.class);
        defaultRendererMap.put(TrackType.CHIP_CHIP, HeatmapRenderer.class);
    }
}

