/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.util.SortingCollection;
import org.apache.log4j.Logger;
import org.broad.igv.tools.sort.SortableRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableRecordCodec
implements SortingCollection.Codec<SortableRecord> {
    private static Logger log = Logger.getLogger(SortableRecordCodec.class);
    DataOutputStream outputStream;
    DataInputStream inputStream;

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = new DataInputStream(inputStream);
    }

    @Override
    public void encode(SortableRecord record) {
        try {
            this.outputStream.writeUTF(record.getChromosome());
            this.outputStream.writeInt(record.getStart());
            this.outputStream.writeUTF(record.getText());
        }
        catch (IOException ex) {
            log.error("Error encoding alignment", ex);
        }
    }

    @Override
    public SortableRecord decode() {
        try {
            String chr = this.inputStream.readUTF();
            int start = this.inputStream.readInt();
            String text = this.inputStream.readUTF();
            return new SortableRecord(chr, start, text);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            log.error("Error decoding alignment", ex);
            return null;
        }
    }

    @Override
    public SortingCollection.Codec<SortableRecord> clone() {
        SortableRecordCodec other = new SortableRecordCodec();
        return other;
    }
}

