/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.tdf.TDFBedTile;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFFixedTile;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.tdf.TDFVaryTile;
import org.broad.igv.tdf.TDFWriter;
import org.broad.igv.tools.Accumulator;
import org.broad.igv.tools.CommandLineStatusMonitor;
import org.broad.igv.tools.CoverageCounter;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.tools.parsers.CNParser;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.tools.parsers.GCTParser;
import org.broad.igv.tools.parsers.UnsortedException;
import org.broad.igv.tools.parsers.WiggleParser;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements DataConsumer {
    private static Logger log = Logger.getLogger(Preprocessor.class);
    boolean compressed = true;
    private boolean skipZeroes = false;
    private int nZoom = 7;
    int maxExtFactor = 0;
    Zoom[] zoomLevels;
    int nTracks;
    Genome genome;
    Collection<WindowFunction> windowFunctions;
    private String currentChr = "";
    int currentChrLength;
    private int sizeEstimate;
    int nPtsProcessed = 0;
    StatusMonitor statusMonitor;
    double percentComplete = 0.0;
    int lastStartPosition = 0;
    HashSet<String> skippedChromosomes = new HashSet();
    TDFWriter writer;
    Raw rawData;
    Zoom genomeZoom;
    File outputFile;
    Accumulator allDataStats;
    List<String> chromosomes = new ArrayList<String>();
    Set<String> visitedChromosomes = new HashSet<String>();
    Map<String, String> attributes = new HashMap<String, String>();
    PrintStream out = System.out;
    List<WindowFunction> allDataFunctions = Arrays.asList(WindowFunction.mean, WindowFunction.median, WindowFunction.min, WindowFunction.max, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.percentile90, WindowFunction.percentile98);

    public Preprocessor(File outputFile, Genome genome, Collection<WindowFunction> windowFunctions, int sizeEstimate, StatusMonitor monitor) {
        this.statusMonitor = monitor;
        this.outputFile = outputFile;
        this.genome = genome;
        this.windowFunctions = windowFunctions;
        this.sizeEstimate = sizeEstimate;
        this.genome = genome;
        this.allDataStats = new Accumulator(this.allDataFunctions);
        if (this.statusMonitor == null) {
            this.statusMonitor = new CommandLineStatusMonitor();
        }
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames) {
        if (this.outputFile != null && this.writer == null) {
            this.writer = new TDFWriter(this.outputFile, this.genome.getId(), trackType, trackLine, trackNames, this.windowFunctions, this.compressed);
            this.nTracks = trackNames.length;
            int genomeLength = (int)(this.genome.getLength() / 1000L);
            this.genomeZoom = new Zoom("All", 0, genomeLength);
            TDFGroup rootGroup = this.writer.getRootGroup();
            rootGroup.setAttribute("genome", this.genome.getId());
            rootGroup.setAttribute("maxZoom", String.valueOf(this.nZoom));
        }
    }

    @Override
    public void addData(String chr, int start, int end, float[] data, String name) {
        if (this.writer == null) {
            return;
        }
        if (this.skipZeroes) {
            boolean allZeroes = true;
            for (int i2 = 0; i2 < data.length; ++i2) {
                if (data[i2] == 0.0f) continue;
                allZeroes = false;
                break;
            }
            if (allZeroes) {
                return;
            }
        }
        if (this.statusMonitor != null && this.statusMonitor.isInterrupted()) {
            throw new PreprocessingException("Preprocessing Halted.");
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        if (this.currentChr != null && chr.equals(this.currentChr)) {
            if (start < this.lastStartPosition - this.maxExtFactor) {
                String msg = "Error: Data is not sorted @ " + chr + " " + start + "  (last position = " + this.lastStartPosition + "   max ext factor = " + this.maxExtFactor + ")";
                this.out.println(msg);
                throw new UnsortedException(msg);
            }
        } else {
            this.newChromosome(chr);
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        int chrLength = this.genome.getChromosome(chr).getLength();
        if (start > chrLength) {
            log.info("Ignoring data from non-existent locus.  Probe = " + name + "  Locus = " + chr + ":" + start + "-" + end + ". " + chr + " length = " + chrLength);
            return;
        }
        this.rawData.addData(start, end, data, name);
        for (Zoom zl : this.zoomLevels) {
            zl.addData(start, end, data);
        }
        long offset = this.genome.getCumulativeOffset(chr);
        int gStart = (int)((offset + (long)start) / 1000L);
        int gEnd = Math.max(gStart + 1, (int)((offset + (long)end) / 1000L));
        if (!(chr.equals("chrM") || chr.equals("M") || chr.equals("MT"))) {
            this.genomeZoom.addData(gStart, gEnd, data);
            for (int i3 = 0; i3 < data.length; ++i3) {
                this.allDataStats.add(data[i3]);
            }
        }
        this.lastStartPosition = start;
    }

    public void newChromosome(String chr) {
        if (this.visitedChromosomes.contains(chr)) {
            String msg = "Error: Data is not ordered by start position. Chromosome " + chr + " appears in multiple blocks";
            this.out.println(msg);
            throw new PreprocessingException(msg);
        }
        this.visitedChromosomes.add(chr);
        Chromosome c2 = this.genome.getChromosome(chr);
        if (c2 == null) {
            this.out.println("Chromosome: " + chr + " not found in .genome file.  Skipping.");
            this.skippedChromosomes.add(chr);
        } else {
            this.chromosomes.add(chr);
            this.out.println();
            this.out.println("Processing chromosome " + chr);
            if (this.zoomLevels != null) {
                for (Zoom zl : this.zoomLevels) {
                    zl.close();
                }
            }
            if (this.rawData != null) {
                this.rawData.close();
            }
            this.currentChr = chr;
            this.currentChrLength = c2.getLength();
            this.zoomLevels = new Zoom[this.getNZoom() + 1];
            for (int z = 0; z <= this.getNZoom(); ++z) {
                this.zoomLevels[z] = new Zoom(chr, z, this.currentChrLength);
            }
            this.rawData = new Raw(chr, this.currentChrLength, 100000);
        }
        this.lastStartPosition = 0;
    }

    @Override
    public void parsingComplete() {
    }

    public void finish() {
        if (this.writer == null) {
            return;
        }
        StringBuffer chrString = new StringBuffer();
        Iterator<String> iter = this.chromosomes.iterator();
        while (iter.hasNext()) {
            chrString.append(iter.next());
            if (!iter.hasNext()) continue;
            chrString.append(",");
        }
        this.writer.getRootGroup().setAttribute("chromosomes", chrString.toString());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.writer.getRootGroup().setAttribute(entry.getKey(), entry.getValue());
        }
        if (this.zoomLevels != null) {
            for (Zoom zl : this.zoomLevels) {
                zl.close();
            }
        }
        this.genomeZoom.close();
        if (this.rawData == null) {
            this.out.println("No features were found that matched chromosomes in genome: " + this.genome.getId());
        } else {
            this.rawData.close();
            this.allDataStats.finish();
            TDFGroup group = this.writer.getGroup("/");
            group.setAttribute("userPercentileAutoscaling", "true");
            for (WindowFunction wf : this.allDataFunctions) {
                group.setAttribute(wf.getDisplayName(), String.valueOf(this.allDataStats.getValue(wf)));
            }
            this.writer.closeFile();
        }
        if (this.statusMonitor != null) {
            this.statusMonitor.setPercentComplete(100.0);
        } else {
            this.out.println("Done");
        }
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void setSortTolerance(int tolerance) {
        this.maxExtFactor = tolerance;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void setSizeEstimate(int sizeEstimate) {
        this.sizeEstimate = sizeEstimate;
    }

    public void setSkipZeroes(boolean skipZeroes) {
        this.skipZeroes = skipZeroes;
    }

    public int getNZoom() {
        return this.nZoom;
    }

    public void setNZoom(int nZoom) {
        this.nZoom = nZoom;
    }

    public int getSizeEstimate() {
        return this.sizeEstimate;
    }

    public static boolean isAlignmentFile(String ext) {
        return ext.equalsIgnoreCase(".bam") || ext.equalsIgnoreCase(".sam") || ext.equalsIgnoreCase(".aligned") || ext.equalsIgnoreCase(".sorted.txt") || ext.equalsIgnoreCase(".bedz") || ext.equalsIgnoreCase(".bed");
    }

    public void count(String iFile, int windowSizeValue, int extFactorValue, int maxZoomValue, File wigFile, int strandOption) throws IOException {
        this.setNZoom(maxZoomValue);
        this.setTrackParameters(TrackType.COVERAGE, null, new String[]{iFile});
        this.setSkipZeroes(true);
        CoverageCounter aParser = new CoverageCounter(iFile, this, windowSizeValue, extFactorValue, wigFile, this.genome, strandOption);
        this.setSizeEstimate((int)(this.genome.getLength() / (long)windowSizeValue));
        aParser.parse();
    }

    public void preprocess(File iFile, String probeFile, int maxZoomValue) throws IOException {
        this.setNZoom(maxZoomValue);
        String tmp = iFile.getAbsolutePath().toLowerCase();
        if (tmp.endsWith(".txt")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        if (tmp.endsWith("wig") || tmp.endsWith("wig.gz") || tmp.endsWith("bedgraph") || tmp.endsWith("bedgraph.gz")) {
            WiggleParser wg = new WiggleParser(iFile.getAbsolutePath(), (DataConsumer)this, this.genome);
            wg.parse();
        } else if (tmp.endsWith(".cn") || tmp.endsWith(".igv") || tmp.endsWith(".cn.gz") || tmp.endsWith(".cn") || tmp.endsWith(".snp")) {
            CNParser cnParser = new CNParser(iFile.getAbsolutePath(), (DataConsumer)this, this.genome);
            cnParser.parse();
        } else if (tmp.endsWith("gct") || tmp.endsWith("gct.gz")) {
            GCTParser gctParser = new GCTParser((DataConsumer)this, iFile, probeFile, this.genome.getId());
            gctParser.parse();
        } else {
            String extension = Preprocessor.getExtension(iFile.getAbsolutePath());
            this.out.println("Error: cannot 'tile' files of type " + extension);
            this.out.println("Valid file extensions are: .cn, .xcn, .cn, .snp, .wig, and .gct");
        }
    }

    public static String getExtension(String filename) {
        int idx;
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        if (filename.toLowerCase().endsWith(".sorted.txt")) {
            return ".sorted.txt";
        }
        if (filename.toLowerCase().endsWith(".txt")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if ((idx = filename.lastIndexOf(46)) < 0) {
            return "";
        }
        return filename.substring(idx).toLowerCase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Tile {
        int totalCount = 0;
        int zoomLevel;
        int tileNumber;
        int tileStart;
        int lastFinishedBin = 0;
        float binWidth;
        int nBins;
        int nonEmptyBins;
        Accumulator[][] accumulators;
        Map<WindowFunction, TDFDataset> datasets;

        Tile(Map<WindowFunction, TDFDataset> datasets, int zoomLevel, int tileNumber, int nBins, int tileWidth) {
            this.datasets = datasets;
            this.zoomLevel = zoomLevel;
            this.tileNumber = tileNumber;
            this.tileStart = tileNumber * tileWidth;
            this.nBins = nBins;
            this.binWidth = (float)tileWidth / (float)nBins;
            this.accumulators = new Accumulator[Preprocessor.this.nTracks][nBins];
        }

        void addData(int start, int end, float[] data) {
            ++this.totalCount;
            int startBin = Math.max(0, (int)((float)(start - this.tileStart) / this.binWidth));
            int endBin = Math.min(this.nBins - 1, (int)((float)(end - this.tileStart) / this.binWidth));
            int tmp = (int)((float)(start - this.tileStart - Preprocessor.this.maxExtFactor) / this.binWidth);
            for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                int b2;
                for (b2 = this.lastFinishedBin; b2 < tmp; ++b2) {
                    if (this.accumulators[t][b2] == null) continue;
                    this.accumulators[t][b2].finish();
                }
                this.lastFinishedBin = Math.max(0, tmp - 1);
                for (b2 = startBin; b2 <= endBin; ++b2) {
                    if (this.accumulators[t][b2] == null) {
                        this.accumulators[t][b2] = new Accumulator(this.datasets.keySet());
                    }
                    this.accumulators[t][b2].add(data[t]);
                }
            }
        }

        void close() {
            this.nonEmptyBins = 0;
            for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                for (int i2 = 0; i2 < this.nBins; ++i2) {
                    if (this.accumulators[t][i2] == null) continue;
                    this.accumulators[t][i2].finish();
                    if (t != 0) continue;
                    ++this.nonEmptyBins;
                }
            }
            TDFTile tile = null;
            for (WindowFunction wf : this.datasets.keySet()) {
                if ((double)this.nonEmptyBins < 0.5 * (double)this.nBins) {
                    int[] starts = new int[this.nonEmptyBins];
                    float[][] data = new float[Preprocessor.this.nTracks][this.nonEmptyBins];
                    int n2 = 0;
                    for (int i3 = 0; i3 < this.nBins; ++i3) {
                        for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                            Accumulator acc = this.accumulators[t][i3];
                            if (acc == null) continue;
                            data[t][n2] = acc.getValue(wf);
                            if (t != Preprocessor.this.nTracks - 1) continue;
                            starts[n2] = (int)((float)this.tileStart + (float)i3 * this.binWidth);
                            ++n2;
                        }
                    }
                    tile = new TDFVaryTile(this.tileStart, this.binWidth, starts, data);
                } else {
                    float[][] data = new float[Preprocessor.this.nTracks][this.nBins];
                    for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                        for (int i4 = 0; i4 < this.nBins; ++i4) {
                            data[t][i4] = this.accumulators[t][i4] == null ? Float.NaN : this.accumulators[t][i4].getValue(wf);
                        }
                    }
                    tile = new TDFFixedTile(this.tileStart, this.tileStart, this.binWidth, data);
                }
                String dsName = this.datasets.get((Object)wf).getName();
                try {
                    Preprocessor.this.writer.writeTile(dsName, this.tileNumber, tile);
                }
                catch (IOException iOException) {
                    log.error("Error writing tile: " + dsName + " [" + this.tileNumber + "]", iOException);
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    class Zoom {
        int level;
        int tileWidth;
        LinkedHashMap<Integer, Tile> activeTiles = new LinkedHashMap();
        Map<WindowFunction, TDFDataset> datasets = new HashMap<WindowFunction, TDFDataset>();

        Zoom(String chr, int level, int chrLength) {
            int nTiles = (int)Math.pow(2.0, level);
            this.tileWidth = chrLength / nTiles + 1;
            this.level = level;
            for (WindowFunction wf : Preprocessor.this.windowFunctions) {
                String dsName = "/" + chr + "/z" + level + "/" + wf.toString();
                this.datasets.put(wf, Preprocessor.this.writer.createDataset(dsName, TDFDataset.DataType.FLOAT, this.tileWidth, nTiles));
            }
        }

        public void addData(int start, int end, float[] data) {
            Tile t;
            Integer tileNumber;
            int startTile = start / this.tileWidth;
            int endTile = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int i2 = startTile; i2 <= endTile; ++i2) {
                t = this.activeTiles.get(i2);
                if (t == null) {
                    t = new Tile(this.datasets, this.level, i2, 700, this.tileWidth);
                    this.activeTiles.put(i2, t);
                }
                t.addData(start, end, data);
            }
        }

        public void close() {
            for (Tile t : this.activeTiles.values()) {
                t.close();
            }
        }
    }

    class Raw {
        String chr;
        String dsName;
        TDFDataset dataset;
        int tileWidth;
        Map<Integer, RawTile> activeTiles = new HashMap<Integer, RawTile>();

        Raw(String chr, int chrLength, int tileWidth) {
            this.tileWidth = tileWidth;
            int nTiles = chrLength / tileWidth + 1;
            this.dsName = "/" + chr + "/raw";
            this.dataset = Preprocessor.this.writer.createDataset(this.dsName, TDFDataset.DataType.FLOAT, tileWidth, nTiles);
        }

        public void addData(int start, int end, float[] data, String name) {
            int p2;
            Integer tileNumber;
            int startTileNumber = start / this.tileWidth;
            int endTileNumber = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                RawTile t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int t = startTileNumber; t <= endTileNumber; ++t) {
                RawTile tile = this.activeTiles.get(t);
                if (tile == null) {
                    tile = new RawTile(this.dsName, t, t * this.tileWidth, (t + 1) * this.tileWidth);
                    this.activeTiles.put(t, tile);
                }
                tile.addData(start, end, data, name);
            }
            if (Preprocessor.this.statusMonitor != null && (double)(p2 = (int)(100.0 * (double)Preprocessor.this.nPtsProcessed / (1.5 * (double)Preprocessor.this.getSizeEstimate()))) > Preprocessor.this.percentComplete) {
                Preprocessor.this.percentComplete = p2;
                Preprocessor.this.statusMonitor.setPercentComplete(Preprocessor.this.percentComplete);
            }
            ++Preprocessor.this.nPtsProcessed;
        }

        void close() {
            for (RawTile t : this.activeTiles.values()) {
                t.close();
            }
            this.activeTiles = null;
        }
    }

    class RawTile {
        String dsName;
        int tileNumber;
        int tileStart;
        int tileEnd;
        IntArrayList startArray;
        IntArrayList endArray;
        ArrayList<String> nameList;
        FloatArrayList[] dataArray;

        RawTile(String dsName, int tileNumber, int start, int end) {
            this.dsName = dsName;
            this.tileNumber = tileNumber;
            this.tileStart = start;
            this.tileEnd = end;
            this.startArray = new IntArrayList();
            this.endArray = new IntArrayList();
            this.dataArray = new FloatArrayList[Preprocessor.this.nTracks];
            for (int i2 = 0; i2 < Preprocessor.this.nTracks; ++i2) {
                this.dataArray[i2] = new FloatArrayList();
            }
        }

        void addData(int start, int end, float[] data, String name) {
            if (start > this.tileEnd) {
                log.info("Warning: start position > tile end");
            }
            if (end < this.tileStart) {
                log.info("Warning: end position > tile end");
            }
            if (name != null && this.nameList == null) {
                this.nameList = new ArrayList();
            }
            int dataStart = Math.max(this.tileStart, start);
            int dataEnd = Math.min(this.tileEnd, end);
            this.startArray.add(dataStart);
            this.endArray.add(dataEnd);
            for (int i2 = 0; i2 < data.length; ++i2) {
                this.dataArray[i2].add(data[i2]);
            }
            if (name != null) {
                this.nameList.add(name);
            }
        }

        void close() {
            try {
                if (this.startArray.size() > 0) {
                    int[] s = this.startArray.toArray();
                    int[] e2 = this.endArray.toArray();
                    float[][] d2 = new float[this.dataArray.length][this.dataArray[0].size()];
                    for (int i2 = 0; i2 < this.dataArray.length; ++i2) {
                        d2[i2] = this.dataArray[i2].toArray();
                    }
                    String[] n2 = this.nameList == null ? null : this.nameList.toArray(new String[0]);
                    TDFBedTile tile = new TDFBedTile(this.tileStart, s, e2, d2, n2);
                    Preprocessor.this.writer.writeTile(this.dsName, this.tileNumber, tile);
                    this.startArray.clear();
                    this.endArray.clear();
                    for (int i3 = 0; i3 < this.dataArray.length; ++i3) {
                        this.dataArray[i3].clear();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

