/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.synteny.SyntenyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntenyUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<SyntenyMapping>> loadMappings(String file, boolean reverse) {
        BufferedReader reader = null;
        HashMap<String, List<SyntenyMapping>> mappings = new HashMap<String, List<SyntenyMapping>>();
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(file));
            Pattern.compile("\t");
            while ((nextLine = reader.readLine()) != null) {
                if (!nextLine.startsWith("region") && !nextLine.startsWith("anchor")) continue;
                String[] tokens = nextLine.split(" ");
                String type = tokens[0];
                String name = tokens[1];
                String fromChr = tokens[2];
                int fromStart = Integer.parseInt(tokens[3]);
                int fromEnd = Integer.parseInt(tokens[4]);
                String fromStrand = tokens[5];
                String toChr = tokens[6];
                int toStart = Integer.parseInt(tokens[7]);
                int toEnd = Integer.parseInt(tokens[8]);
                String toStrand = tokens[9];
                SyntenyMapping syntenyMapping = null;
                syntenyMapping = reverse ? new SyntenyMapping(name, toChr, toStart, toEnd, toStrand, fromChr, fromStart, fromEnd, fromStrand) : new SyntenyMapping(name, fromChr, fromStart, fromEnd, fromStrand, toChr, toStart, toEnd, toStrand);
                ArrayList<SyntenyMapping> syntenyMappingList = (ArrayList<SyntenyMapping>)mappings.get(syntenyMapping.getFromChr());
                if (syntenyMappingList == null) {
                    syntenyMappingList = new ArrayList<SyntenyMapping>(1000);
                    mappings.put(syntenyMapping.getFromChr(), syntenyMappingList);
                }
                syntenyMappingList.add(syntenyMapping);
            }
            for (List syntenyMappingList : mappings.values()) {
                SyntenyUtils.sortMappingList(syntenyMappingList);
            }
            HashMap<String, List<SyntenyMapping>> hashMap = mappings;
            return hashMap;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            Map<String, List<SyntenyMapping>> map = null;
            return map;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SyntenyMapping getMappingContaining(List<SyntenyMapping> mappings, int fromPosition) {
        int idx;
        for (int i2 = idx = SyntenyUtils.getIndexBefore(mappings, fromPosition); i2 < mappings.size(); ++i2) {
            SyntenyMapping mapping = mappings.get(i2);
            if (!mapping.containsFromPosition(fromPosition)) continue;
            return mapping;
        }
        return null;
    }

    public static List<SyntenyMapping> getMappingsOverlapping(List<SyntenyMapping> mappings, int fromStart, int fromEnd) {
        SyntenyMapping mapping;
        int idx;
        int i2;
        int i1 = -1;
        int i22 = -1;
        for (i2 = idx = SyntenyUtils.getIndexBefore(mappings, fromStart); i2 < mappings.size(); ++i2) {
            mapping = mappings.get(i2);
            if (mapping.containsFromPosition(fromStart)) {
                i1 = idx;
                break;
            }
            if (mapping.getFromStart() <= fromStart) continue;
            i1 = idx;
            break;
        }
        for (i2 = idx = SyntenyUtils.getIndexBefore(mappings, fromEnd); i2 < mappings.size(); ++i2) {
            mapping = mappings.get(i2);
            if (mapping.containsFromPosition(fromEnd)) {
                i22 = idx;
                break;
            }
            if (mapping.getFromStart() <= fromStart) continue;
            i22 = Math.max(i1, idx - 1);
            break;
        }
        if (i1 < 0 || i22 < 0) {
            return null;
        }
        return mappings.subList(i1, i22 + 1);
    }

    private static void sortMappingList(List<SyntenyMapping> features) {
        Collections.sort(features, new Comparator<SyntenyMapping>(){

            @Override
            public int compare(SyntenyMapping o1, SyntenyMapping o2) {
                return o1.getFromStart() - o2.getFromStart();
            }
        });
    }

    private static int getIndexBefore(List<SyntenyMapping> values, int x) {
        return SyntenyUtils.getIndexBefore(values, x, 0, values.size());
    }

    private static int getIndexBefore(List<SyntenyMapping> values, int x, int leftBound, int rightBound) {
        int idx = (leftBound + rightBound) / 2;
        if (idx == 0 || idx == values.size() - 1) {
            return idx;
        }
        if (values.get(idx).getFromStart() == x) {
            return idx;
        }
        if (values.get(idx).getFromStart() < x) {
            if (values.get(idx + 1).getFromStart() >= x) {
                return idx;
            }
            leftBound = idx;
            return SyntenyUtils.getIndexBefore(values, x, leftBound, rightBound);
        }
        if (values.get(idx - 1).getFromStart() <= x) {
            return idx - 1;
        }
        rightBound = idx;
        return SyntenyUtils.getIndexBefore(values, x, leftBound, rightBound);
    }
}

