/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataUtils;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.data.WiggleParser;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.synteny.BlastMapping;
import org.broad.igv.synteny.BlastParser;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlastMappingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void MapWigFile(WiggleDataset dataset, List<BlastMapping> mappings, File outputFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            LinkedHashMap<String, ArrayList<BlastMapping>> featureMap = new LinkedHashMap<String, ArrayList<BlastMapping>>();
            for (BlastMapping f2 : mappings) {
                ArrayList<BlastMapping> fList = (ArrayList<BlastMapping>)featureMap.get(f2.getChr());
                if (fList == null) {
                    fList = new ArrayList<BlastMapping>();
                    featureMap.put(f2.getChr(), fList);
                }
                fList.add(f2);
            }
            for (List featureList : featureMap.values()) {
                FeatureUtils.sortFeatureList(featureList);
            }
            pw.println("Chr\tStart\tEnd\t\tnucCount (Kwal)");
            for (String chr : featureMap.keySet()) {
                List mappingList = (List)featureMap.get(chr);
                ArrayList<BasicScore> scores = new ArrayList<BasicScore>(mappingList.size());
                for (BlastMapping mapping : mappingList) {
                    BlastMapping.Block queryBlock = mapping.getQueryBlock();
                    BlastMapping.Block subjectBlock = mapping.getSubjectBlock();
                    int[] subjectPosition = dataset.getStartLocations(subjectBlock.getContig());
                    float[] data = dataset.getData("ignore", subjectBlock.getContig());
                    int s0 = subjectBlock.getStart();
                    int s1 = subjectBlock.getEnd();
                    int q0 = queryBlock.getStart();
                    int q1 = queryBlock.getEnd();
                    int idx0 = DataUtils.getIndexBefore(subjectPosition, Math.min(s0, s1));
                    int idx1 = DataUtils.getIndexBefore(subjectPosition, Math.max(s0, s1)) + 1;
                    if (idx1 == subjectPosition.length) {
                        --idx1;
                    }
                    double beta = (double)(q1 - q0) / (double)(s1 - s0);
                    for (int i2 = idx0; i2 <= idx1; ++i2) {
                        int pos = (int)((double)q0 + beta * (double)(subjectPosition[i2] - s0));
                        float d2 = data[i2];
                        scores.add(new BasicScore(chr, pos, pos + 1, d2));
                    }
                }
                FeatureUtils.sortFeatureList(scores);
                for (BasicScore s : scores) {
                    pw.println(s.getChromosome() + "\t" + s.getStart() + "\t" + (s.getEnd() + 1) + "\t\t" + s.getScore());
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            pw.close();
        }
    }

    public static void main(String[] args) {
        String file = "/Users/jrobinso/Alex/Cgla_v_Kwal1.orthologs";
        String wiggleFile = "/Users/jrobinso/IGVTestData/alex/nucCount_Kwal.wig";
        File outputFile = new File("/Users/jrobinso/Alex/uncount_Kwal_to_Cgla.igv");
        List<BlastMapping> mappings = new BlastParser().parse(file);
        WiggleDataset ds = new WiggleParser(new ResourceLocator(wiggleFile), "Kwal").parse();
        BlastMappingUtils.MapWigFile(ds, mappings, outputFile);
    }
}

